/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.qa.browserdriver.manager.defaults;

import com.assertthat.selenium_shutterbug.utils.web.Browser;
import com.assertthat.selenium_shutterbug.utils.web.ScrollStrategy;
import com.assertthat.selenium_shutterbug.utils.web.UnableTakeSnapshotException;
import com.google.common.base.Function;
import edu.uci.qa.browserdriver.BrowserDriver;
import edu.uci.qa.browserdriver.manager.BrowserDriverManager;
import edu.uci.qa.browserdriver.reports.Report;
import edu.uci.qa.browserdriver.reports.ReportsTest;
import edu.uci.qa.browserdriver.screenshot.ElementShot;
import edu.uci.qa.browserdriver.screenshot.Screenshot;
import edu.uci.qa.browserdriver.utils.AES;
import edu.uci.qa.browserdriver.utils.CryptConfig;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Base64;
import java.util.List;
import java.util.Set;
import org.openqa.selenium.By;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.HasCapabilities;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.Actions;
import org.openqa.selenium.interactions.HasInputDevices;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.support.ui.ExpectedCondition;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.WebDriverWait;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultManager
implements BrowserDriverManager {
    protected final BrowserDriver browser;
    protected final WebDriver driver;
    protected String sessionId;
    protected Capabilities capabilities;
    protected Actions actions;
    protected Report report;
    private long timeout = 10L;

    public DefaultManager(BrowserDriver browser, WebDriver driver) {
        this.browser = browser;
        this.driver = driver;
    }

    @Override
    public void postInstantiation() {
        this.sessionId = this.driver instanceof RemoteWebDriver ? ((RemoteWebDriver)this.driver).getSessionId().toString() : "";
        this.capabilities = this.driver instanceof HasCapabilities ? ((HasCapabilities)this.driver).getCapabilities() : null;
        Actions actions = this.actions = this.driver instanceof HasInputDevices ? new Actions(this.driver) : null;
        if (this.getBrowser() != edu.uci.qa.browserdriver.utils.Browser.Headless && this.getBrowser() != edu.uci.qa.browserdriver.utils.Browser.Sauce) {
            this.browser.manage().window().maximize();
        }
    }

    @Override
    @Deprecated
    public void sleep(long timeout) throws InterruptedException {
        this.browser.logger().info("Sleeping for " + timeout + " milliseconds.");
        Thread.sleep(timeout);
    }

    @Override
    public Capabilities getCapabilities() {
        return this.capabilities;
    }

    @Override
    public String getSessionId() {
        return this.sessionId;
    }

    @Override
    public edu.uci.qa.browserdriver.utils.Browser getBrowser() {
        return edu.uci.qa.browserdriver.utils.Browser.None;
    }

    @Override
    public String getVersion() {
        return this.browser.getCapabilities().getVersion();
    }

    @Override
    public boolean hasQuit() {
        return ((RemoteWebDriver)this.driver).getSessionId() == null;
    }

    @Override
    public Actions actionBuilder() {
        return this.actions;
    }

    @Override
    public WebDriver webDriver() {
        return this.driver;
    }

    @Override
    public Logger logger() {
        return LoggerFactory.getLogger((String)"BrowserDriver");
    }

    public void get(String url) {
        this.browser.logger().info("Navigating current window to: " + url);
        this.driver.get(url);
    }

    public String getCurrentUrl() {
        return this.driver.getCurrentUrl();
    }

    public String getTitle() {
        return this.driver.getTitle();
    }

    public List<WebElement> findElements(By by) {
        this.browser.logger().info("Finding elements with " + by.toString());
        return this.driver.findElements(by);
    }

    public WebElement findElement(By by) {
        this.browser.logger().info("Finding element with " + by.toString());
        return this.driver.findElement(by);
    }

    public String getPageSource() {
        return this.driver.getPageSource();
    }

    public void close() {
        this.browser.logger().info("Attempting to close window with handle: " + this.getWindowHandle());
        this.driver.close();
    }

    public void quit() {
        this.browser.logger().info("Attempting to quit the driver and close all associated windows");
        this.driver.quit();
    }

    public Set<String> getWindowHandles() {
        return this.driver.getWindowHandles();
    }

    public String getWindowHandle() {
        return this.driver.getWindowHandle();
    }

    public WebDriver.TargetLocator switchTo() {
        return this.driver.switchTo();
    }

    public WebDriver.Navigation navigate() {
        return this.driver.navigate();
    }

    public WebDriver.Options manage() {
        return this.driver.manage();
    }

    @Override
    public void setDefaultTimeout(long timeout) {
        this.timeout = timeout;
    }

    @Override
    public long defaultTimeoutInSeconds() {
        return this.timeout;
    }

    @Override
    public <V> V waitUntil(Function<? super WebDriver, V> condition) {
        return this.waitUntil(condition, this.defaultTimeoutInSeconds());
    }

    @Override
    public <V> V waitUntil(Function<? super WebDriver, V> condition, long timeout) {
        this.browser.logger().info("Waiting for (at most) " + timeout + " seconds.");
        return (V)new WebDriverWait(this.driver, timeout).until(condition);
    }

    @Override
    public boolean isPresent(By locator) {
        this.browser.logger().info("Waiting for presence of " + locator);
        return this.driver.findElements(locator).size() > 0;
    }

    @Override
    public boolean isPresent(final By locator, long timeout) {
        this.browser.logger().info("Waiting for presence of " + locator);
        try {
            return (Boolean)this.browser.waitUntil(new ExpectedCondition<Boolean>(){

                public Boolean apply(WebDriver input) {
                    return DefaultManager.this.driver.findElements(locator).size() > 0;
                }
            }, timeout);
        }
        catch (TimeoutException t) {
            return false;
        }
    }

    @Override
    public WebElement click(By locator) {
        return this.click(locator, this.browser.defaultTimeoutInSeconds());
    }

    @Override
    public WebElement click(By locator, long timeout) {
        this.browser.logger().info("Waiting for clickability of " + locator);
        WebElement out = (WebElement)this.browser.waitUntil(ExpectedConditions.elementToBeClickable((By)locator), timeout);
        out.click();
        this.browser.logger().info(locator + " clicked!");
        return out;
    }

    @Override
    public WebElement clear(By locator) {
        return this.clear(locator, this.defaultTimeoutInSeconds());
    }

    @Override
    public WebElement clear(By locator, long timeout) {
        this.browser.logger().info("Waiting for visibility of " + locator);
        WebElement out = (WebElement)this.browser.waitUntil(ExpectedConditions.visibilityOfElementLocated((By)locator), timeout);
        out.clear();
        this.browser.logger().info(locator + " cleared!");
        return out;
    }

    @Override
    public String getText(By locator) {
        return this.getText(locator, this.defaultTimeoutInSeconds());
    }

    @Override
    public String getText(By locator, long timeout) {
        this.browser.logger().info("Waiting for visibility of " + locator);
        WebElement element = (WebElement)this.browser.waitUntil(ExpectedConditions.visibilityOfElementLocated((By)locator), timeout);
        return element.getText();
    }

    @Override
    public WebElement sendKeys(By locator, String keysToSend) {
        return this.sendKeys(locator, keysToSend, this.defaultTimeoutInSeconds());
    }

    @Override
    public WebElement sendKeys(By locator, String keysToSend, long timeout) {
        this.browser.logger().info("Waiting for visibility of " + locator);
        WebElement out = (WebElement)this.browser.waitUntil(ExpectedConditions.visibilityOfElementLocated((By)locator), timeout);
        out.sendKeys(new CharSequence[]{keysToSend});
        this.browser.logger().info("Successfully sent the following character sequence: " + keysToSend);
        return out;
    }

    @Override
    public void scrollTo(By locator) {
        if (this.browser.isPresent(locator)) {
            this.scrollTo(this.browser.findElement(locator));
        } else {
            this.browser.logger().warn("Unable to locate element using " + locator + ". Skipping scrollTo!");
        }
    }

    @Override
    public void scrollTo(WebElement element) {
        this.browser.logger().info("Scrolling to " + element);
        this.browser.executeScript("arguments[0].scrollIntoView(true);", element);
    }

    @Override
    public Object executeScript(String script, Object ... args) {
        this.browser.logger().info("Executing JavaScript: " + script);
        return ((JavascriptExecutor)this.driver).executeScript(script, args);
    }

    @Override
    public void setReport(Report report) {
        if (this.report == null) {
            this.report = report;
        } else {
            this.browser.logger().warn("Reporter has already been instantiated. Close the reporter before setting an external one!");
        }
    }

    @Override
    public ReportsTest startTest(String testName) {
        return this.startTest(testName, "");
    }

    @Override
    public ReportsTest startTest(String testName, String description) {
        if (this.report == null) {
            this.report = new Report();
        }
        return (ReportsTest)this.report.startTest(testName, description);
    }

    @Override
    public ReportsTest getTest() {
        return this.report == null ? null : this.report.getTest();
    }

    @Override
    public void endTest() {
        if (this.report != null) {
            this.report.endTest();
        }
    }

    @Override
    public void flush() {
        if (this.report != null) {
            this.report.flush();
        }
    }

    @Override
    public void closeReport() {
        if (this.report != null) {
            this.report.close();
            this.report = null;
        }
    }

    @Override
    public Screenshot screenshot() {
        return this.screenshot(ScrollStrategy.BOTH_DIRECTIONS);
    }

    @Override
    public Screenshot screenshot(ScrollStrategy scroll) {
        Screenshot s;
        this.browser.logger().info("Taking screenshot of current page with ScrollStrategy " + scroll);
        try {
            Browser b = new Browser(this.driver);
            b.setScrollTimeout(100);
            s = new Screenshot(this.browser);
            int startTop = b.getCurrentScrollY();
            int startLeft = b.getCurrentScrollX();
            this.browser.executeScript("document.body.style.overflow='hidden';", new Object[0]);
            switch (scroll) {
                case HORIZONTALLY: {
                    s.setImage(b.takeScreenshotScrollHorizontally());
                    break;
                }
                case VERTICALLY: {
                    s.setImage(b.takeScreenshotScrollVertically());
                    break;
                }
                default: {
                    s.setImage(b.takeScreenshotEntirePage());
                }
            }
            this.browser.executeScript("document.body.style.overflow='visible';", new Object[0]);
            b.scrollTo(startTop, startLeft);
        }
        catch (Throwable t) {
            throw new UnableTakeSnapshotException("Snapshots are not supported by the current browser!", t);
        }
        return s;
    }

    @Override
    public ElementShot screenshot(By locator) {
        this.browser.logger().info("Taking screenshot at " + locator);
        WebElement el = (WebElement)this.browser.waitUntil(ExpectedConditions.visibilityOfElementLocated((By)locator));
        return this.screenshot(el);
    }

    @Override
    public ElementShot screenshot(WebElement element) {
        this.browser.logger().info("Taking Screenshot of " + element);
        Browser b = new Browser(this.driver);
        ElementShot out = new ElementShot(this.browser);
        this.browser.scrollTo(element);
        this.browser.executeScript("document.body.style.overflow='hidden';", new Object[0]);
        out.setImage(b.takeScreenshot(), b.getBoundingClientRect(element));
        this.browser.executeScript("document.body.style.overflow='visible';", new Object[0]);
        return out;
    }

    @Override
    public Screenshot screenshotViewport() {
        Screenshot s;
        this.browser.logger().info("Taking screenshot of the current viewport.");
        try {
            Browser b = new Browser(this.driver);
            s = new Screenshot(this.browser);
            this.browser.executeScript("document.body.style.overflow='hidden';", new Object[0]);
            s.setImage(b.takeScreenshot());
            this.browser.executeScript("document.body.style.overflow='visible';", new Object[0]);
        }
        catch (Throwable t) {
            throw new UnableTakeSnapshotException("An unknown error occurred when attempting to take a snapshot", t);
        }
        return s;
    }

    @Override
    public String encrypt(String input) {
        ByteArrayInputStream is = null;
        try {
            is = new ByteArrayInputStream(input.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException impossible) {
            return null;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            AES.encrypt(CryptConfig.getConfig().keyLength, CryptConfig.getConfig().passphrase.toCharArray(), is, out);
        }
        catch (IOException e) {
            this.logger().error("IOException occured when encrypting string '" + input + "'");
            return null;
        }
        return Base64.getEncoder().encodeToString(out.toByteArray());
    }

    @Override
    public String decrypt(String input) {
        ByteArrayInputStream is = new ByteArrayInputStream(Base64.getDecoder().decode(input));
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            AES.decrypt(CryptConfig.getConfig().passphrase.toCharArray(), is, out);
        }
        catch (IOException e) {
            this.logger().error("IOException occured when decrypting string '" + input + "'");
            return null;
        }
        return new String(out.toByteArray());
    }
}

