/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.qa.browserdriver.reports;

import com.relevantcodes.extentreports.DisplayOrder;
import com.relevantcodes.extentreports.ExtentReports;
import com.relevantcodes.extentreports.ExtentTest;
import com.relevantcodes.extentreports.NetworkMode;
import edu.uci.qa.browserdriver.BrowserConfig;
import edu.uci.qa.browserdriver.reports.ReportsTest;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class Report
extends ExtentReports {
    private static final long serialVersionUID = 8788241461948189609L;
    private final Map<Long, ReportsTest> tests;
    private final String reportName;
    private final File reportFile;

    public Report() {
        this(BrowserConfig.getInstance().getSaveFolder().getAbsolutePath() + "/reports/" + new SimpleDateFormat("yyyy_MM_dd_HH_mm_ss_SSS").format(new Date()) + ".html");
    }

    public Report(File folder) {
        this(folder.getAbsolutePath() + "/" + new SimpleDateFormat("yyyy_MM_dd_HH_mm_ss_SSS").format(new Date()) + ".html");
    }

    public Report(File folder, String name) {
        this(folder.getAbsolutePath() + "/" + name);
    }

    public Report(String filePath, Boolean replaceExisting, DisplayOrder displayOrder, NetworkMode networkMode, Locale locale) {
        super(filePath, replaceExisting, displayOrder, networkMode, locale);
        this.reportFile = new File(filePath);
        String filename = this.reportFile.getName();
        int pos = filename.lastIndexOf(46);
        this.reportName = pos > 0 ? filename.substring(0, pos) : filename;
        this.tests = new HashMap<Long, ReportsTest>();
    }

    public Report(String filePath, Boolean replaceExisting, DisplayOrder displayOrder, NetworkMode networkMode) {
        this(filePath, replaceExisting, displayOrder, networkMode, null);
    }

    public Report(String filePath, Boolean replaceExisting, DisplayOrder displayOrder, Locale locale) {
        this(filePath, replaceExisting, displayOrder, null, locale);
    }

    public Report(String filePath, Boolean replaceExisting, DisplayOrder displayOrder) {
        this(filePath, replaceExisting, displayOrder, null, null);
    }

    public Report(String filePath, Boolean replaceExisting, NetworkMode networkMode, Locale locale) {
        this(filePath, replaceExisting, null, networkMode, locale);
    }

    public Report(String filePath, Boolean replaceExisting, NetworkMode networkMode) {
        this(filePath, replaceExisting, null, networkMode, null);
    }

    public Report(String filePath, NetworkMode networkMode) {
        this(filePath, null, null, networkMode, null);
    }

    public Report(String filePath, Boolean replaceExisting, Locale locale) {
        this(filePath, replaceExisting, null, null, locale);
    }

    public Report(String filePath, Boolean replaceExisting) {
        this(filePath, replaceExisting, null, null, null);
    }

    public Report(String filePath, Locale locale) {
        this(filePath, null, null, null, locale);
    }

    public Report(String filePath) {
        this(filePath, null, null, null, null);
    }

    public synchronized ExtentTest startTest(String testName, String description) {
        if (this.testList == null) {
            this.testList = new ArrayList();
        }
        if (this.tests.containsKey(Thread.currentThread().getId())) {
            throw new RuntimeException("Thread already as a test running! Thread ID already in use!");
        }
        ReportsTest test = new ReportsTest(testName, description, this.reportFile);
        this.tests.put(Thread.currentThread().getId(), test);
        this.updateTestQueue(test);
        return test;
    }

    public synchronized ReportsTest getTest() {
        return this.tests.get(Thread.currentThread().getId());
    }

    public synchronized void endTest() {
        ExtentTest test = this.tests.remove(Thread.currentThread().getId());
        if (test != null) {
            this.endTest(test);
        }
    }

    public synchronized void endTest(ExtentTest extentTest) {
        super.endTest(extentTest);
    }

    public int getCount() {
        return this.tests.size();
    }

    public String getReportName() {
        return this.reportName;
    }
}

