/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.qa.browserdriver.sauce;

import edu.uci.qa.browserdriver.sauce.SauceLabs;
import edu.uci.qa.browserdriver.utils.Browser;
import edu.uci.qa.browserdriver.utils.Device;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Platform;
import org.openqa.selenium.remote.DesiredCapabilities;

public class SauceCapabilities
extends DesiredCapabilities {
    private static final long serialVersionUID = -1380944927471796914L;

    public SauceCapabilities() {
        this.setCapability("_sauce", true);
    }

    public SauceCapabilities(Capabilities cap) {
        super(cap);
    }

    public SauceCapabilities name(String name) {
        this.setCapability("name", name);
        return this;
    }

    public SauceCapabilities tags(String[] tags) {
        this.setCapability("tags", tags);
        return this;
    }

    public SauceCapabilities build(String build) {
        this.setCapability("build", build);
        return this;
    }

    public Platform getPlatform() {
        return null;
    }

    public final edu.uci.qa.browserdriver.utils.Platform platform() {
        if (this.getCapability("platform") != null) {
            if (this.getCapability("platform") instanceof Platform) {
                return SauceCapabilities.convert(this.getCapability("platform"));
            }
            if (this.getCapability("platform") instanceof String) {
                return edu.uci.qa.browserdriver.utils.Platform.fromString((String)this.getCapability("platform"));
            }
        }
        return null;
    }

    private static edu.uci.qa.browserdriver.utils.Platform convert(Object platform) {
        return edu.uci.qa.browserdriver.utils.Platform.fromString(((Platform)platform).getPartOfOsName()[0]);
    }

    public final Browser getBrowser() {
        return (Browser)this.getCapability("browserType");
    }

    public final Device getDevice() {
        return (Device)this.getCapability("deviceType");
    }

    public final boolean isDevice() {
        return this.getCapability("deviceType") != null;
    }

    public final boolean isBrowser() {
        return this.getCapability("browserType") != null;
    }

    public final SauceLabs.Orientation getOrientation() {
        return SauceLabs.Orientation.valueOf((String)this.getCapability("deviceOrientation"));
    }

    public final String getVersion() {
        String out = (String)this.getCapability("version");
        if (out == null || out.isEmpty()) {
            out = (String)this.getCapability("platformVersion");
        }
        return out;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.isBrowser()) {
            sb.append("OS: " + (Object)((Object)this.platform()) + ",");
            sb.append(" Browser: " + this.getBrowser() + ",");
            sb.append(" Version: " + this.getVersion());
        } else {
            sb.append("Device: " + this.getDevice().toString() + ",");
            sb.append(" Version: " + this.getVersion() + ",");
            sb.append(" Orientation: " + (Object)((Object)this.getOrientation()));
        }
        return sb.toString();
    }
}

