/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.qa.browserdriver.screenshot;

import com.assertthat.selenium_shutterbug.utils.file.FileUtil;
import com.assertthat.selenium_shutterbug.utils.image.ImageProcessor;
import edu.uci.qa.browserdriver.manager.WebDriverManager;
import edu.uci.qa.browserdriver.screenshot.Shot;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.List;
import org.openqa.selenium.Point;

public class ComparisonShot<T extends Shot<T>>
extends Shot<ComparisonShot<T>> {
    private double diff;
    private double deviation;
    private List<Point> failPoints;
    private T oldShot;
    private T newShot;

    ComparisonShot(WebDriverManager driver, T oldS, T newS, BufferedImage image, double diff, double deviation, String location, String name, List<Point> failPoints) {
        super(driver);
        this.oldShot = oldS;
        this.newShot = newS;
        this.setImage(image);
        this.diff = diff;
        this.deviation = deviation;
        this.locExtension = location;
        if (name != null) {
            this.fileName = name;
        }
        this.suffix = "-DIFF.png";
        this.failPoints = failPoints;
    }

    public final List<Point> getFailPoints() {
        return this.failPoints;
    }

    public final double getDiff() {
        return this.diff;
    }

    public final double getAllowedDeviation() {
        return this.deviation;
    }

    public boolean isEqual() {
        return this.diff <= this.deviation;
    }

    public final T getOld() {
        return this.oldShot;
    }

    public final T getNew() {
        return this.newShot;
    }

    public final T getSBS() {
        int width = Math.max(this.getOld().getImage().getWidth(), this.getNew().getImage().getWidth());
        int height = Math.max(this.getOld().getImage().getHeight(), this.getNew().getImage().getHeight());
        BufferedImage mergeImage = new BufferedImage(width * 3 + 6, height + 30, 1);
        Graphics2D graph = mergeImage.createGraphics();
        graph.drawImage(ImageProcessor.addTitle((BufferedImage)this.getOld().getImage(), (String)"OLD", (Color)Color.WHITE, (Font)new Font("Serif", 1, 30)), null, 0, 0);
        graph.drawImage(ImageProcessor.addTitle((BufferedImage)this.image, (String)"DIFF", (Color)Color.WHITE, (Font)new Font("Serif", 1, 30)), null, this.getOld().getImage().getWidth() + 3, 0);
        graph.drawImage(ImageProcessor.addTitle((BufferedImage)this.getNew().getImage(), (String)"NEW", (Color)Color.WHITE, (Font)new Font("Serif", 1, 30)), null, this.getOld().getImage().getWidth() + this.image.getWidth() + 6, 0);
        graph.dispose();
        T image = null;
        try {
            image = ((Shot)((Object)this.getOld())).newInstance(mergeImage);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return image;
    }

    public void saveAll() {
        File loc = new File(this.location.toString(), this.locExtension + "/");
        FileUtil.writeImage((BufferedImage)this.oldShot.getImage(), (String)"PNG", (File)new File(loc, this.fileName + "-OLD.png"));
        FileUtil.writeImage((BufferedImage)this.newShot.getImage(), (String)"PNG", (File)new File(loc, this.fileName + "-NEW.png"));
        FileUtil.writeImage((BufferedImage)this.image, (String)"PNG", (File)new File(loc, this.fileName + "-DIFF.png"));
        this.saveSBS();
    }

    public void saveSBS() {
        FileUtil.writeImage((BufferedImage)this.getSBS().getImage(), (String)"PNG", (File)new File(this.location.toString(), this.locExtension + "/" + this.fileName + "-SBS.png"));
    }

    protected ComparisonShot<T> self() {
        return this;
    }
}

