/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.qa.browserdriver.screenshot;

import com.assertthat.selenium_shutterbug.utils.image.ImageProcessor;
import com.assertthat.selenium_shutterbug.utils.web.Coordinates;
import edu.uci.qa.browserdriver.manager.WebDriverManager;
import edu.uci.qa.browserdriver.screenshot.ComparisonShot;
import edu.uci.qa.browserdriver.screenshot.Shot;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import org.openqa.selenium.Point;

public final class ScreenshotProcessor
extends ImageProcessor {
    public static BufferedImage cover(BufferedImage image, Coordinates coords) {
        return ScreenshotProcessor.cover(image, coords, Color.black);
    }

    public static BufferedImage cover(BufferedImage image, Coordinates coords, Color color) {
        BufferedImage combined = new BufferedImage(image.getWidth(), image.getHeight(), 2);
        Graphics2D g = combined.createGraphics();
        g.drawImage((Image)image, 0, 0, null);
        g.setColor(color);
        g.fillRect(coords.getX(), coords.getY(), coords.getWidth(), coords.getHeight());
        g.dispose();
        return combined;
    }

    public static <T extends Shot<T>> ComparisonShot<T> compare(WebDriverManager driver, String location, String name, double deviation, T baseImage, T shotImage) {
        int sizeDeviance = 10;
        int width = Math.min(baseImage.getImage().getWidth(), shotImage.getImage().getWidth());
        int height = Math.min(baseImage.getImage().getHeight(), shotImage.getImage().getHeight());
        ArrayList<Point> failPoints = new ArrayList<Point>();
        BufferedImage diffImage = new BufferedImage(width, height, 1);
        if (Math.abs(baseImage.getImage().getWidth() - shotImage.getImage().getWidth()) > sizeDeviance || Math.abs(baseImage.getImage().getHeight() - shotImage.getImage().getHeight()) > sizeDeviance) {
            driver.logger().warn("Images dimensions mismatch: base - " + baseImage.getImage().getWidth() + "x" + baseImage.getImage().getHeight() + "; shot - " + shotImage.getImage().getWidth() + "x" + shotImage.getImage().getHeight());
            return new ComparisonShot<T>(driver, baseImage, shotImage, diffImage, deviation + 1.0, deviation, location, name, failPoints);
        }
        int diff = 0;
        int result = 0;
        long out = 0L;
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                int shotPixel;
                int basePixel = baseImage.getImage().getRGB(x, y);
                if (basePixel != (shotPixel = shotImage.getImage().getRGB(x, y))) {
                    failPoints.add(new Point(x, y));
                    int baseRed = basePixel >> 16 & 0xFF;
                    int baseGreen = basePixel >> 8 & 0xFF;
                    int baseBlue = basePixel & 0xFF;
                    int shotRed = shotPixel >> 16 & 0xFF;
                    int shotGreen = shotPixel >> 8 & 0xFF;
                    int shotBlue = shotPixel & 0xFF;
                    diff += Math.abs(baseRed - shotRed);
                    diff += Math.abs(baseBlue - shotBlue);
                    diff += Math.abs(baseGreen - shotGreen);
                    out += (long)Math.abs(baseRed - shotRed);
                    out += (long)Math.abs(baseBlue - shotBlue);
                    out += (long)Math.abs(baseGreen - shotGreen);
                    result = (diff /= 3) << 16 | diff << 8 | diff;
                    diffImage.setRGB(x, y, result *= Color.MAGENTA.getRGB());
                    continue;
                }
                diffImage.setRGB(x, y, shotPixel);
            }
        }
        double n = width * height * 3;
        double p = (double)out / n / 255.0;
        return new ComparisonShot<T>(driver, baseImage, shotImage, diffImage, p, deviation, location, name, failPoints);
    }
}

