/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.qa.browserdriver.screenshot;

import com.assertthat.selenium_shutterbug.core.Snapshot;
import com.assertthat.selenium_shutterbug.utils.file.FileUtil;
import com.assertthat.selenium_shutterbug.utils.image.ImageProcessor;
import edu.uci.qa.browserdriver.BrowserConfig;
import edu.uci.qa.browserdriver.manager.WebDriverManager;
import edu.uci.qa.browserdriver.screenshot.ComparisonShot;
import edu.uci.qa.browserdriver.screenshot.ScreenshotProcessor;
import java.awt.Color;
import java.awt.Font;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.Base64;
import java.util.Date;
import javax.imageio.ImageIO;

public abstract class Shot<T extends Shot<T>>
extends Snapshot<T> {
    String title;
    Path location;
    String fileName;
    String locExtension = "";
    String suffix = ".png";

    public Shot(WebDriverManager browser) {
        this.driver = browser;
        this.location = Paths.get(BrowserConfig.getInstance().getSaveFolder().getAbsolutePath() + "/screenshots/", new String[0]);
        this.fileName = new SimpleDateFormat("yyyy_MM_dd_HH_mm_ss_SSS").format(new Date());
    }

    public T withBaseLocation(File location) {
        this.location = Paths.get(location.getAbsolutePath(), new String[0]);
        return (T)((Object)((Shot)this.self()));
    }

    public T withSuffix(String suffix) {
        if (suffix != null && !suffix.isEmpty()) {
            this.suffix = "-" + suffix + ".png";
        }
        return (T)((Object)((Shot)this.self()));
    }

    public T withName(String name) {
        if (name != null) {
            this.fileName = name;
        }
        return (T)((Object)((Shot)this.self()));
    }

    public T withLocation(String path) {
        this.locExtension = path;
        return (T)((Object)((Shot)this.self()));
    }

    public String getLocationExtension() {
        return this.locExtension;
    }

    public String getFileName() {
        return this.fileName;
    }

    public T withThumbnail(double scale) {
        return (T)((Object)((Shot)this.withThumbnail(Paths.get(this.location.toString() + this.locExtension + "/", "./thumbnails").toString(), "thumb_" + this.fileName + this.suffix, scale)));
    }

    public T withTitle(String title) {
        this.title = title;
        return (T)((Object)((Shot)this.self()));
    }

    public File getSaveFile() {
        return new File(this.location.toString() + "/" + this.locExtension + "/", this.fileName + this.suffix);
    }

    public void save() {
        File screenshotFile = new File(this.location.toString() + "/" + this.locExtension + "/", this.fileName + this.suffix);
        screenshotFile.mkdirs();
        if (this.title != null && !this.title.isEmpty()) {
            this.image = ImageProcessor.addTitle((BufferedImage)this.image, (String)this.title, (Color)Color.red, (Font)new Font("Serif", 1, 20));
        }
        FileUtil.writeImage((BufferedImage)this.image, (String)"PNG", (File)screenshotFile);
    }

    T newInstance(BufferedImage img) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        Shot out = (Shot)((Object)((Object)((Object)this)).getClass().getConstructor(WebDriverManager.class).newInstance((WebDriverManager)this.driver));
        if (out != null) {
            out.image = img;
        }
        return (T)((Object)out);
    }

    public String toBase64() {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)this.image, "png", os);
        }
        catch (Exception e) {
            return "";
        }
        return "data:image/png;base64," + Base64.getEncoder().encodeToString(os.toByteArray());
    }

    public ComparisonShot<T> compare() {
        return this.compare(0.0);
    }

    public ComparisonShot<T> compare(double deviation) {
        BufferedImage base;
        File baseImage = new File(this.location.toString() + "/" + this.locExtension + "/", this.fileName + this.suffix);
        if (!baseImage.exists()) {
            this.save();
        }
        try {
            base = ImageIO.read(baseImage);
        }
        catch (IOException e) {
            throw new UnknownError("An unknown error occurred when attempting to load screenshot");
        }
        Shot baseShot = null;
        try {
            baseShot = this.newInstance(base);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ScreenshotProcessor.compare((WebDriverManager)this.driver, this.locExtension, baseImage.getName().substring(0, baseImage.getName().lastIndexOf(46)), deviation, baseShot, (Shot)this.self());
    }

    public ComparisonShot<T> compareTo(T otherShot) {
        return this.compareTo(otherShot, 0.0);
    }

    public ComparisonShot<T> compareTo(T otherShot, double deviation) {
        return ScreenshotProcessor.compare((WebDriverManager)this.driver, this.locExtension, this.fileName, deviation, otherShot, (Shot)this.self());
    }

    public void setImage(BufferedImage image) {
        super.setImage(image);
    }
}

