/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.qa.browserdriver.testing;

import com.relevantcodes.extentreports.LogStatus;
import edu.uci.qa.browserdriver.reports.ReportsTest;
import edu.uci.qa.browserdriver.testing.BrowserProvider;
import edu.uci.qa.browserdriver.testing.Provider;
import edu.uci.qa.browserdriver.testing.ProviderTestWatcher;
import edu.uci.qa.browserdriver.testing.ReportProvider;
import org.junit.AssumptionViolatedException;
import org.junit.runner.Description;
import org.junit.runners.model.MultipleFailureException;
import org.openqa.selenium.WebDriverException;

public class ReportTestWatcher
extends ProviderTestWatcher {
    public ReportTestWatcher(Provider provider) {
        super(provider);
    }

    public ReportTestWatcher(Provider provider, boolean verboseMode) {
        super(provider, verboseMode);
    }

    protected void skipped(AssumptionViolatedException e, Description description) {
        if (this.provider instanceof ReportProvider) {
            ReportProvider p = (ReportProvider)this.provider;
            ReportsTest test = p.getReport().getTest();
            if (p.getReport().getTest() == null) {
                test = (ReportsTest)p.getReport().startTest(description.getMethodName());
            }
            test.log(LogStatus.SKIP, "<span class='skip label'>JUnit</span> Skipped");
            p.getReport().endTest();
            p.getReport().flush();
        } else if (this.provider instanceof BrowserProvider) {
            BrowserProvider p = (BrowserProvider)this.provider;
            ReportsTest test = p.getBrowser().getTest();
            if (p.getBrowser().getTest() == null) {
                test = p.getBrowser().startTest(description.getMethodName());
            }
            test.log(LogStatus.SKIP, "<span class='skip label'>JUnit</span> Skipped");
            p.getBrowser().endTest();
            p.getBrowser().flush();
        }
    }

    protected void succeeded(Description description) {
        if (this.provider instanceof ReportProvider) {
            ReportProvider p = (ReportProvider)this.provider;
            ReportsTest test = p.getReport().getTest();
            if (p.getReport().getTest() == null) {
                test = (ReportsTest)p.getReport().startTest(description.getMethodName());
            }
            test.log(LogStatus.PASS, "<span class='success label'>JUnit</span> Passed");
            p.getReport().endTest();
            p.getReport().flush();
        } else if (this.provider instanceof BrowserProvider) {
            BrowserProvider p = (BrowserProvider)this.provider;
            ReportsTest test = p.getBrowser().getTest();
            if (p.getBrowser().getTest() == null) {
                test = p.getBrowser().startTest(description.getMethodName());
            }
            test.log(LogStatus.PASS, "<span class='success label'>JUnit</span> Passed");
            p.getBrowser().endTest();
            p.getBrowser().flush();
        }
    }

    protected void failed(Throwable e, Description description) {
        if (this.provider instanceof ReportProvider) {
            ReportProvider p = (ReportProvider)this.provider;
            ReportsTest test = p.getReport().getTest();
            if (p.getReport().getTest() == null) {
                test = (ReportsTest)p.getReport().startTest(description.getMethodName());
            }
            this.logTest(test, e);
            test.log(LogStatus.FAIL, "<span class='fail label'>JUnit</span> Failed");
            p.getReport().endTest();
            p.getReport().flush();
        } else if (this.provider instanceof BrowserProvider) {
            BrowserProvider p = (BrowserProvider)this.provider;
            ReportsTest test = p.getBrowser().getTest();
            if (p.getBrowser().getTest() == null) {
                test = p.getBrowser().startTest(description.getMethodName());
            }
            this.logTest(test, e);
            test.log(LogStatus.FAIL, "<span class='fail label'>JUnit</span> Failed");
            p.getBrowser().endTest();
            p.getBrowser().flush();
        }
    }

    private void logTest(ReportsTest test, Throwable e) {
        if (e != null) {
            if (e instanceof AssertionError || e instanceof WebDriverException) {
                test.log(LogStatus.FAIL, "<span class='fail label'>JUnit</span> " + e.getMessage());
            } else if (e instanceof MultipleFailureException) {
                for (Throwable t : ((MultipleFailureException)e).getFailures()) {
                    this.logTest(test, t);
                }
            } else {
                test.log(LogStatus.ERROR, e);
            }
        }
    }
}

