/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.qa.browserdriver.testing;

import com.relevantcodes.extentreports.LogStatus;
import edu.uci.qa.browserdriver.screenshot.Screenshot;
import edu.uci.qa.browserdriver.testing.BrowserProvider;
import edu.uci.qa.browserdriver.testing.BrowserTestWatcher;
import org.junit.AssumptionViolatedException;
import org.junit.runner.Description;
import org.openqa.selenium.TimeoutException;

public class ScreenshotTestWatcher
extends BrowserTestWatcher {
    protected Screenshot failShot;

    public ScreenshotTestWatcher(BrowserProvider provider) {
        this(provider, false);
    }

    public ScreenshotTestWatcher(BrowserProvider provider, boolean verboseMode) {
        super(provider, verboseMode);
    }

    protected void succeeded(Description description) {
        if (this.provider != null && !this.provider.getBrowser().hasQuit()) {
            this.provider.getBrowser().quit();
        }
    }

    protected void skipped(AssumptionViolatedException e, Description description) {
        if (this.provider != null && !this.provider.getBrowser().hasQuit()) {
            this.provider.getBrowser().quit();
        }
    }

    protected void failed(Throwable e, Description description) {
        if (this.provider != null && !this.provider.getBrowser().hasQuit()) {
            this.failShot = this.provider.getBrowser().screenshotViewport();
            if (e instanceof TimeoutException) {
                this.failShot.withTitle(e.getCause().getMessage());
            } else {
                this.failShot.withTitle(e.getMessage());
            }
            ((Screenshot)((Object)this.failShot.withLocation("fails"))).save();
            if (this.provider.getBrowser().getTest() != null) {
                this.provider.getBrowser().getTest().log(LogStatus.FAIL, this.failShot);
            }
            this.provider.getBrowser().quit();
        }
    }
}

