/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.qa.browserdriver.utils;

import edu.uci.qa.browserdriver.utils.Version;
import java.util.Comparator;
import org.openqa.selenium.WebDriverException;

public enum Platform {
    Windows(new String[]{"windows"}){

        @Override
        public Platform family() {
            return Windows;
        }

        public String toString() {
            return "Windows";
        }
    }
    ,
    WindowsXP(new String[]{"Windows 2003", "Windows Server 2003", "windows xp", "xp", "winnt"}){

        @Override
        public Platform family() {
            return Windows;
        }

        public String toString() {
            return "Windows XP";
        }

        @Override
        public Version version() {
            return new Version("5");
        }

        @Override
        public org.openqa.selenium.Platform seleniumPlatform() {
            return org.openqa.selenium.Platform.XP;
        }
    }
    ,
    Windows8(new String[]{"Windows 2012", "Windows Server 2012", "windows 8", "win8"}){

        @Override
        public Platform family() {
            return Windows;
        }

        public String toString() {
            return "Windows 8";
        }

        @Override
        public Version version() {
            return new Version("8");
        }

        @Override
        public org.openqa.selenium.Platform seleniumPlatform() {
            return org.openqa.selenium.Platform.WIN8;
        }
    }
    ,
    Windows8_1(new String[]{"Windows 2012 R2", "windows 8.1", "win8.1"}){

        @Override
        public Platform family() {
            return Windows;
        }

        public String toString() {
            return "Windows 8.1";
        }

        @Override
        public Version version() {
            return new Version("8.1");
        }

        @Override
        public org.openqa.selenium.Platform seleniumPlatform() {
            return org.openqa.selenium.Platform.WIN8_1;
        }
    }
    ,
    Windows7(new String[]{"Windows 2008", "windows 7", "win7", "windows vista"}){

        @Override
        public Platform family() {
            return Windows;
        }

        public String toString() {
            return "Windows 7";
        }

        @Override
        public Version version() {
            return new Version("7");
        }

        @Override
        public org.openqa.selenium.Platform seleniumPlatform() {
            return org.openqa.selenium.Platform.VISTA;
        }
    }
    ,
    Windows10(new String[]{"Windows 10", "win10"}){

        @Override
        public Platform family() {
            return Windows;
        }

        public String toString() {
            return "Windows 10";
        }

        @Override
        public Version version() {
            return new Version("10");
        }

        @Override
        public org.openqa.selenium.Platform seleniumPlatform() {
            return org.openqa.selenium.Platform.WIN10;
        }
    }
    ,
    Mac(new String[]{"mac", "osx", "os x"}){

        @Override
        public Platform family() {
            return Mac;
        }

        public String toString() {
            return "OS X";
        }
    }
    ,
    El_Capitan(new String[]{"Mac 10.11", "OS X 10.11", "os x el capitan", "osx el capitan", "el capitan"}){

        @Override
        public Platform family() {
            return Mac;
        }

        public String toString() {
            return "OS X El Capitan";
        }

        @Override
        public Version version() {
            return new Version("10.11");
        }

        @Override
        public org.openqa.selenium.Platform seleniumPlatform() {
            return org.openqa.selenium.Platform.EL_CAPITAN;
        }
    }
    ,
    Mavericks(new String[]{"Mac 10.9", "OS X 10.9", "osx mavericks", "os x mavericks", "mavericks"}){

        @Override
        public Platform family() {
            return Mac;
        }

        public String toString() {
            return "OS X Mavericks";
        }

        @Override
        public Version version() {
            return new Version("10.9");
        }

        @Override
        public org.openqa.selenium.Platform seleniumPlatform() {
            return org.openqa.selenium.Platform.MAVERICKS;
        }
    }
    ,
    Mountain_Lion(new String[]{"Mac 10.8", "OS X 10.8", "osx mountain lion", "os x mountain lion", "mountain lion"}){

        @Override
        public Platform family() {
            return Mac;
        }

        public String toString() {
            return "OS X Mountain Lion";
        }

        @Override
        public Version version() {
            return new Version("10.8");
        }

        @Override
        public org.openqa.selenium.Platform seleniumPlatform() {
            return org.openqa.selenium.Platform.MOUNTAIN_LION;
        }
    }
    ,
    Yosemite(new String[]{"Mac 10.10", "OS X 10.10", "osx yosemite", "os x yosemite", "yosemite"}){

        @Override
        public Platform family() {
            return Mac;
        }

        public String toString() {
            return "OS X Yosemite";
        }

        @Override
        public Version version() {
            return new Version("10.10");
        }

        @Override
        public org.openqa.selenium.Platform seleniumPlatform() {
            return org.openqa.selenium.Platform.YOSEMITE;
        }
    }
    ,
    Sierra(new String[]{"Mac 10.12", "OS X 10.12", "osx sierra", "os x sierra", "sierra"}){

        @Override
        public Platform family() {
            return Mac;
        }

        public String toString() {
            return "OS X Sierra";
        }

        @Override
        public Version version() {
            return new Version("10.12");
        }

        @Override
        public org.openqa.selenium.Platform seleniumPlatform() {
            return org.openqa.selenium.Platform.MAC;
        }
    }
    ,
    Linux(new String[]{"linux"}){

        @Override
        public org.openqa.selenium.Platform seleniumPlatform() {
            return org.openqa.selenium.Platform.LINUX;
        }

        public String toString() {
            return "Linux";
        }
    }
    ,
    Any(new String[0]);

    private final String[] names;

    private Platform(String ... names) {
        this.names = names;
    }

    public String[] getNames() {
        return this.names;
    }

    public Platform family() {
        return Any;
    }

    public org.openqa.selenium.Platform seleniumPlatform() {
        return org.openqa.selenium.Platform.ANY;
    }

    public Version version() {
        return new Version("0.0.0");
    }

    public static Platform fromString(String name) {
        try {
            return Platform.valueOf(name);
        }
        catch (IllegalArgumentException e) {
            for (Platform os : Platform.values()) {
                for (String matcher : os.names) {
                    if (!name.equalsIgnoreCase(matcher)) continue;
                    return os;
                }
            }
            throw new WebDriverException("Unrecognized platform: " + name);
        }
    }

    public static class PlatformComparator
    implements Comparator<Platform> {
        @Override
        public int compare(Platform o1, Platform o2) {
            if (o1.family() != o2.family()) {
                return o1.family() == Windows ? 1 : -1;
            }
            return o1.version().compareTo(o2.version());
        }
    }
}

