/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.qa.browserdriver.utils;

public class Version
implements Comparable<Version> {
    private String version;
    private static final int[] PRIME = new int[]{2, 3, 5};

    public Version(String version) {
        if (version == null) {
            throw new IllegalArgumentException("Version can not be null");
        }
        this.version = version;
    }

    public final String get() {
        return this.version;
    }

    public int hashCode() {
        String[] parts = this.get().split("\\.");
        int hashCode = 0;
        for (int i = 0; i < parts.length; ++i) {
            int part = Integer.parseInt(parts[i]);
            if (part <= 0) continue;
            hashCode += PRIME[i] ^ part;
        }
        return hashCode;
    }

    @Override
    public int compareTo(Version that) {
        if (that == null) {
            return 1;
        }
        String[] thisParts = this.get().split("\\.");
        String[] thatParts = that.get().split("\\.");
        int length = Math.max(thisParts.length, thatParts.length);
        for (int i = 0; i < length; ++i) {
            int thatPart;
            int thisPart = i < thisParts.length ? Integer.parseInt(thisParts[i]) : 0;
            int n = thatPart = i < thatParts.length ? Integer.parseInt(thatParts[i]) : 0;
            if (thisPart < thatPart) {
                return -1;
            }
            if (thisPart <= thatPart) continue;
            return 1;
        }
        return 0;
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null) {
            return false;
        }
        if (this.getClass() != that.getClass()) {
            return false;
        }
        return this.compareTo((Version)that) == 0;
    }

    public String toString() {
        return this.get();
    }
}

