/*
 * Decompiled with CFR 0.152.
 */
package edu.vt.middleware.ldap.handler;

import edu.vt.middleware.ldap.Ldap;
import edu.vt.middleware.ldap.handler.CopyAttributeHandler;
import edu.vt.middleware.ldap.handler.ExtendedAttributeHandler;
import edu.vt.middleware.ldap.handler.SearchCriteria;
import java.util.ArrayList;
import java.util.List;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RecursiveAttributeHandler
extends CopyAttributeHandler
implements ExtendedAttributeHandler {
    private Ldap ldap;
    private String attributeName;

    public RecursiveAttributeHandler(String attrName) {
        this(null, attrName);
    }

    public RecursiveAttributeHandler(Ldap l, String attrName) {
        this.ldap = l;
        this.attributeName = attrName;
    }

    @Override
    public Ldap getSearchResultLdap() {
        return this.ldap;
    }

    @Override
    public void setSearchResultLdap(Ldap l) {
        this.ldap = l;
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    public void setAttributeName(String s) {
        this.attributeName = s;
    }

    @Override
    protected Attribute processResult(SearchCriteria sc, Attribute attr) throws NamingException {
        BasicAttribute newAttr;
        block6: {
            newAttr = null;
            if (attr == null) break block6;
            newAttr = new BasicAttribute(attr.getID(), attr.isOrdered());
            if (attr.getID().equals(this.attributeName)) {
                NamingEnumeration<?> en = attr.getAll();
                while (en.hasMore()) {
                    Object rawValue = this.processValue(sc, en.next());
                    if (rawValue instanceof String) {
                        List<String> recursiveValues = this.recursiveSearch((String)rawValue, new ArrayList<String>());
                        for (String s : recursiveValues) {
                            newAttr.add(this.processValue(sc, s));
                        }
                        continue;
                    }
                    newAttr.add(rawValue);
                }
            } else {
                NamingEnumeration<?> en = attr.getAll();
                while (en.hasMore()) {
                    newAttr.add(this.processValue(sc, en.next()));
                }
            }
        }
        return newAttr;
    }

    private List<String> recursiveSearch(String dn, List<String> searchedDns) throws NamingException {
        ArrayList<String> results = new ArrayList<String>();
        if (!searchedDns.contains(dn)) {
            Attribute attr;
            Attributes attrs;
            block5: {
                attrs = null;
                try {
                    attrs = this.ldap.getAttributes(dn, new String[]{this.attributeName});
                    results.add(dn);
                }
                catch (NamingException e) {
                    if (!this.logger.isWarnEnabled()) break block5;
                    this.logger.warn((Object)("Error retreiving attribute: " + this.attributeName), (Throwable)e);
                }
            }
            searchedDns.add(dn);
            if (attrs != null && (attr = attrs.get(this.attributeName)) != null) {
                NamingEnumeration<?> en = attr.getAll();
                while (en.hasMore()) {
                    Object rawValue = en.next();
                    if (!(rawValue instanceof String)) continue;
                    results.addAll(this.recursiveSearch((String)rawValue, searchedDns));
                }
            }
        }
        return results;
    }
}

