/*
 * Decompiled with CFR 0.152.
 */
package org.sandbox;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="install", defaultPhase=LifecyclePhase.INITIALIZE)
public final class GitHookInstallMojo
extends AbstractMojo {
    private static final String SHEBANG = "#!/bin/sh";
    private static final Path HOOK_DIR_PATH = Paths.get(".git/hooks", new String[0]);
    @Parameter
    private Map<String, String> hooks;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!Files.exists(HOOK_DIR_PATH, new LinkOption[0])) {
            throw new MojoExecutionException("not a git repository");
        }
        for (Map.Entry<String, String> hook : this.hooks.entrySet()) {
            String hookName = hook.getKey();
            String finalScript = "#!/bin/sh\n" + hook.getValue();
            try {
                Files.write(HOOK_DIR_PATH.resolve(hookName), finalScript.getBytes(), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
                Files.setPosixFilePermissions(HOOK_DIR_PATH.resolve(hookName), new HashSet<PosixFilePermission>(Arrays.asList(PosixFilePermission.OWNER_EXECUTE, PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_WRITE)));
            }
            catch (IOException e) {
                throw new MojoExecutionException("could not write hook with name: " + hookName, (Exception)e);
            }
        }
    }
}

