/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.api.internal;

import io.github.detekt.psi.KtFilesKt;
import io.gitlab.arturbosch.detekt.api.internal.SignaturesKt;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.kdoc.psi.api.KDoc;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParameterList;
import org.jetbrains.kotlin.psi.KtSuperTypeListEntry;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000,\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a\f\u0010\t\u001a\u00020\u0003*\u00020\nH\u0000\u001a\f\u0010\u000b\u001a\u00020\u0003*\u00020\nH\u0002\u001a\f\u0010\f\u001a\u00020\u0003*\u00020\rH\u0002\u001a\f\u0010\u000e\u001a\u00020\u0003*\u00020\nH\u0000\u001a\f\u0010\u000f\u001a\u00020\u0003*\u00020\nH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"multipleWhitespaces", "Lkotlin/text/Regex;", "buildClassSignature", "", "classOrObject", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "buildFunctionSignature", "element", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "buildFullSignature", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "extractClassName", "fileSignature", "Lorg/jetbrains/kotlin/psi/KtFile;", "searchName", "searchSignature", "detekt-api"})
public final class SignaturesKt {
    private static final Regex multipleWhitespaces = new Regex("\\s{2,}");

    @NotNull
    public static final String searchName(@NotNull PsiElement $this$searchName) {
        Intrinsics.checkNotNullParameter((Object)$this$searchName, (String)"$this$searchName");
        Object object = LightClassUtilsKt.getNamedUnwrappedElement((PsiElement)$this$searchName);
        if (object == null || (object = object.getName()) == null) {
            object = "<UnknownName>";
        }
        return object;
    }

    @NotNull
    public static final String buildFullSignature(@NotNull PsiElement $this$buildFullSignature) {
        Intrinsics.checkNotNullParameter((Object)$this$buildFullSignature, (String)"$this$buildFullSignature");
        String fullSignature = SignaturesKt.searchSignature($this$buildFullSignature);
        String parentSignatures2 = CollectionsKt.joinToString$default((Iterable)CollectionsKt.reversed((Iterable)SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)PsiUtilsKt.getParents((PsiElement)$this$buildFullSignature), (Function1)buildFullSignature.parentSignatures.1.INSTANCE), (Function1)buildFullSignature.parentSignatures.2.INSTANCE))), (CharSequence)".", null, null, (int)0, null, null, (int)62, null);
        CharSequence charSequence = parentSignatures2;
        boolean bl = false;
        if (charSequence.length() > 0) {
            fullSignature = parentSignatures2 + '$' + fullSignature;
        }
        PsiFile psiFile = $this$buildFullSignature.getContainingFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"this.containingFile");
        String filename = KtFilesKt.getFileName((PsiFile)psiFile);
        if (!StringsKt.startsWith$default((String)fullSignature, (String)filename, (boolean)false, (int)2, null)) {
            fullSignature = filename + '$' + fullSignature;
        }
        return fullSignature;
    }

    private static final String extractClassName(PsiElement $this$extractClassName) {
        PsiElement $this$getNonStrictParentOfType$iv = $this$extractClassName;
        boolean $i$f$getNonStrictParentOfType = false;
        Object object = (KtClassOrObject)PsiTreeUtil.getParentOfType((PsiElement)$this$getNonStrictParentOfType$iv, KtClassOrObject.class, (boolean)false);
        if (object == null || (object = object.getNameAsSafeName()) == null || (object = object.asString()) == null) {
            object = "";
        }
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"this.getNonStrictParentO\u2026afeName?.asString() ?: \"\"");
        return object;
    }

    private static final String searchSignature(PsiElement $this$searchSignature) {
        Object object = $this$searchSignature;
        String string = object instanceof KtNamedFunction ? SignaturesKt.buildFunctionSignature((KtNamedFunction)$this$searchSignature) : (object instanceof KtClassOrObject ? SignaturesKt.buildClassSignature((KtClassOrObject)$this$searchSignature) : (object instanceof KtFile ? SignaturesKt.fileSignature((KtFile)$this$searchSignature) : $this$searchSignature.getText()));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"when (this) {\n        is\u2026  else -> this.text\n    }");
        object = StringsKt.replace$default((String)string, (char)'\n', (char)' ', (boolean)false, (int)4, null);
        Regex regex = multipleWhitespaces;
        String string2 = " ";
        boolean bl = false;
        return regex.replace((CharSequence)object, string2);
    }

    private static final String fileSignature(KtFile $this$fileSignature) {
        return $this$fileSignature.getPackageFqName().asString() + '.' + KtFilesKt.getFileName((PsiFile)((PsiFile)$this$fileSignature));
    }

    private static final String buildClassSignature(KtClassOrObject classOrObject) {
        String string = classOrObject.getNameAsSafeName().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"classOrObject.nameAsSafeName.asString()");
        String baseName = string;
        List list = classOrObject.getTypeParameters();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"classOrObject.typeParameters");
        List typeParameters = list;
        if (typeParameters.size() > 0) {
            baseName = baseName + "<";
            baseName = baseName + CollectionsKt.joinToString$default((Iterable)typeParameters, (CharSequence)", ", null, null, (int)0, null, (Function1)buildClassSignature.1.INSTANCE, (int)30, null);
            baseName = baseName + ">";
        }
        List extendedEntries = classOrObject.getSuperTypeListEntries();
        Collection collection = extendedEntries;
        boolean bl = false;
        if (!collection.isEmpty()) {
            baseName = baseName + " : ";
        }
        Iterable $this$forEach$iv = extendedEntries;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KtSuperTypeListEntry it = (KtSuperTypeListEntry)element$iv;
            boolean bl2 = false;
            StringBuilder stringBuilder = new StringBuilder().append(baseName);
            Object object = it.getTypeAsUserType();
            if (object == null || (object = object.getReferencedName()) == null) {
                object = "";
            }
            baseName = stringBuilder.append((String)object).toString();
        }
        return baseName;
    }

    private static final String buildFunctionSignature(KtNamedFunction element) {
        int n;
        boolean bl;
        int methodStart = 0;
        KDoc kDoc = element.getDocComment();
        if (kDoc != null) {
            KDoc kDoc2 = kDoc;
            boolean bl2 = false;
            bl = false;
            KDoc it = kDoc2;
            boolean bl3 = false;
            KDoc kDoc3 = it;
            Intrinsics.checkNotNullExpressionValue((Object)kDoc3, (String)"it");
            methodStart = PsiUtilsKt.getEndOffset((PsiElement)((PsiElement)kDoc3)) - PsiUtilsKt.getStartOffset((PsiElement)((PsiElement)it));
        }
        int methodEnd = PsiUtilsKt.getEndOffset((PsiElement)((PsiElement)element)) - PsiUtilsKt.getStartOffset((PsiElement)((PsiElement)element));
        KtTypeReference typeReference = element.getTypeReference();
        if (typeReference != null) {
            methodEnd = PsiUtilsKt.getEndOffset((PsiElement)((PsiElement)typeReference)) - PsiUtilsKt.getStartOffset((PsiElement)((PsiElement)element));
        } else {
            KtParameterList ktParameterList = element.getValueParameterList();
            if (ktParameterList != null) {
                KtParameterList ktParameterList2 = ktParameterList;
                boolean bl4 = false;
                n = 0;
                KtParameterList it = ktParameterList2;
                boolean bl5 = false;
                KtParameterList ktParameterList3 = it;
                Intrinsics.checkNotNullExpressionValue((Object)ktParameterList3, (String)"it");
                methodEnd = PsiUtilsKt.getEndOffset((PsiElement)((PsiElement)ktParameterList3)) - PsiUtilsKt.getStartOffset((PsiElement)((PsiElement)element));
            }
        }
        bl = methodStart < methodEnd;
        int n2 = 0;
        n = 0;
        if (!bl) {
            boolean bl6 = false;
            String string = "Error building function signature with range " + methodStart + " - " + methodEnd + " for element: " + element.getText();
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        String string = element.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"element.text");
        String string2 = string;
        n2 = methodStart;
        n = methodEnd;
        boolean bl7 = false;
        String string3 = string2;
        if (string3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string4 = string3.substring(n2, n);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        return string4;
    }

    public static final /* synthetic */ String access$extractClassName(PsiElement $this$access_u24extractClassName) {
        return SignaturesKt.extractClassName($this$access_u24extractClassName);
    }
}

