/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.api;

import io.gitlab.arturbosch.detekt.api.BaseConfig;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.HierarchicalConfig;
import io.gitlab.arturbosch.detekt.api.Notification;
import io.gitlab.arturbosch.detekt.api.internal.ValidatableConfiguration;
import io.gitlab.arturbosch.detekt.api.internal.ValidatableConfigurationKt;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.yaml.snakeyaml.Yaml;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 \u001f2\u00020\u00012\u00020\u0002:\u0001\u001fB%\b\u0000\u0012\u0012\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0005H\u0016J\b\u0010\u0011\u001a\u00020\u0005H\u0016J$\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0015\u001a\u00020\u000f2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0016J'\u0010\u0019\u001a\u0002H\u001a\"\b\b\u0000\u0010\u001a*\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u0002H\u001aH\u0016\u00a2\u0006\u0002\u0010\u001cJ!\u0010\u001d\u001a\u0004\u0018\u0001H\u001a\"\b\b\u0000\u0010\u001a*\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0005H\u0016\u00a2\u0006\u0002\u0010\u001eR\u0016\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001d\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006 "}, d2={"Lio/gitlab/arturbosch/detekt/api/YamlConfig;", "Lio/gitlab/arturbosch/detekt/api/BaseConfig;", "Lio/gitlab/arturbosch/detekt/api/internal/ValidatableConfiguration;", "properties", "", "", "", "parent", "Lio/gitlab/arturbosch/detekt/api/HierarchicalConfig$Parent;", "(Ljava/util/Map;Lio/gitlab/arturbosch/detekt/api/HierarchicalConfig$Parent;)V", "getParent", "()Lio/gitlab/arturbosch/detekt/api/HierarchicalConfig$Parent;", "getProperties", "()Ljava/util/Map;", "subConfig", "Lio/gitlab/arturbosch/detekt/api/Config;", "key", "toString", "validate", "", "Lio/gitlab/arturbosch/detekt/api/Notification;", "baseline", "excludePatterns", "", "Lkotlin/text/Regex;", "valueOrDefault", "T", "default", "(Ljava/lang/String;Ljava/lang/Object;)Ljava/lang/Object;", "valueOrNull", "(Ljava/lang/String;)Ljava/lang/Object;", "Companion", "detekt-api"})
public final class YamlConfig
extends BaseConfig
implements ValidatableConfiguration {
    @NotNull
    private final Map<String, Object> properties;
    @Nullable
    private final HierarchicalConfig.Parent parent;
    private static final String YAML = ".yml";
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public Config subConfig(@NotNull String key) {
        Object subProperties;
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        Map<String, Object> map = this.properties;
        boolean bl = false;
        Object object = map.get(key);
        if (object == null) {
            boolean bl2 = false;
            boolean bl3 = false;
            object = MapsKt.emptyMap();
        }
        Object object2 = subProperties = object;
        if (object2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any>");
        }
        return new YamlConfig((Map)object2, new HierarchicalConfig.Parent(this, key));
    }

    @Override
    @NotNull
    public <T> T valueOrDefault(@NotNull String key, @NotNull T t) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        Intrinsics.checkParameterIsNotNull(t, (String)"default");
        Object result = this.properties.get(key);
        Object object = this.valueOrDefaultInternal(key, result, t);
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type T");
        }
        return (T)object;
    }

    @Override
    @Nullable
    public <T> T valueOrNull(@NotNull String key) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        Object object = this.properties.get(key);
        if (!(object instanceof Object)) {
            object = null;
        }
        return (T)object;
    }

    @NotNull
    public String toString() {
        return "YamlConfig(properties=" + this.properties + ')';
    }

    @Override
    @NotNull
    public List<Notification> validate(@NotNull Config baseline, @NotNull Set<Regex> excludePatterns) {
        Intrinsics.checkParameterIsNotNull((Object)baseline, (String)"baseline");
        Intrinsics.checkParameterIsNotNull(excludePatterns, (String)"excludePatterns");
        return ValidatableConfigurationKt.validateConfig(this, baseline, excludePatterns);
    }

    @NotNull
    public final Map<String, Object> getProperties() {
        return this.properties;
    }

    @Override
    @Nullable
    public HierarchicalConfig.Parent getParent() {
        return this.parent;
    }

    public YamlConfig(@NotNull Map<String, ? extends Object> properties, @Nullable HierarchicalConfig.Parent parent) {
        Intrinsics.checkParameterIsNotNull(properties, (String)"properties");
        this.properties = properties;
        this.parent = parent;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lio/gitlab/arturbosch/detekt/api/YamlConfig$Companion;", "", "()V", "YAML", "", "load", "Lio/gitlab/arturbosch/detekt/api/Config;", "reader", "Ljava/io/BufferedReader;", "path", "Ljava/nio/file/Path;", "loadResource", "url", "Ljava/net/URL;", "detekt-api"})
    public static final class Companion {
        @NotNull
        public final Config load(@NotNull Path path) {
            Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
            boolean bl = Files.exists(path, new LinkOption[0]);
            boolean bl2 = false;
            boolean bl3 = false;
            if (!bl) {
                boolean bl4 = false;
                String string = "Unable to load config from '" + path + "': file does not exist!";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            bl = StringsKt.endsWith$default((String)((Object)path).toString(), (String)YamlConfig.YAML, (boolean)false, (int)2, null);
            bl2 = false;
            bl3 = false;
            if (!bl) {
                boolean bl5 = false;
                String string = "Invalid config file name " + path + ": file does not end with .yml!";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            BufferedReader bufferedReader = Files.newBufferedReader(path);
            Intrinsics.checkExpressionValueIsNotNull((Object)bufferedReader, (String)"Files.newBufferedReader(path)");
            return this.load(bufferedReader);
        }

        @NotNull
        public final Config loadResource(@NotNull URL url) {
            Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
            InputStream inputStream = url.openStream();
            Intrinsics.checkExpressionValueIsNotNull((Object)inputStream, (String)"url.openStream()");
            InputStream inputStream2 = inputStream;
            Companion companion = this;
            Charset charset = Charsets.UTF_8;
            boolean bl = false;
            Closeable closeable = inputStream2;
            int n = 0;
            closeable = new InputStreamReader((InputStream)closeable, charset);
            n = 8192;
            boolean bl2 = false;
            BufferedReader bufferedReader = closeable instanceof BufferedReader ? (BufferedReader)closeable : new BufferedReader((Reader)closeable, n);
            return companion.load(bufferedReader);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final Config load(BufferedReader reader) {
            Config config;
            Closeable closeable = reader;
            boolean bl = false;
            Throwable throwable = null;
            try {
                Config config2;
                BufferedReader it = (BufferedReader)closeable;
                boolean bl2 = false;
                String yamlInput = SequencesKt.joinToString$default((Sequence)TextStreamsKt.lineSequence((BufferedReader)it), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
                CharSequence charSequence = yamlInput;
                boolean bl3 = false;
                if (charSequence.length() == 0) {
                    config2 = Config.Companion.getEmpty();
                } else {
                    Object object = new Yaml().load(yamlInput);
                    Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"Yaml().load(yamlInput)");
                    Object map = object;
                    if (!(map instanceof Map)) {
                        throw (Throwable)new Config.InvalidConfigurationError(null, 1, null);
                    }
                    config2 = new YamlConfig((Map)map, null);
                }
                config = config2;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            return config;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

