/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.api.internal;

import io.gitlab.arturbosch.detekt.api.DetektVisitor;
import io.gitlab.arturbosch.detekt.api.internal.CyclomaticComplexity;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.lexer.KtSingleValueToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtBreakExpression;
import org.jetbrains.kotlin.psi.KtCallElement;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtContinueExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtLambdaArgument;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtLoopExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectLiteralExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtTryExpression;
import org.jetbrains.kotlin.psi.KtWhenEntry;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 &2\u00020\u0001:\u0002&'B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u001e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u001fH\u0016J\u0010\u0010 \u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020!H\u0016J\u0012\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#*\u00020!H\u0002J\f\u0010%\u001a\u00020\u000b*\u00020\u0015H\u0002R\u001e\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lio/gitlab/arturbosch/detekt/api/internal/CyclomaticComplexity;", "Lio/gitlab/arturbosch/detekt/api/DetektVisitor;", "config", "Lio/gitlab/arturbosch/detekt/api/internal/CyclomaticComplexity$Config;", "(Lio/gitlab/arturbosch/detekt/api/internal/CyclomaticComplexity$Config;)V", "<set-?>", "", "complexity", "getComplexity", "()I", "isInsideObjectLiteral", "", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "visitBinaryExpression", "", "expression", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "visitBreakExpression", "Lorg/jetbrains/kotlin/psi/KtBreakExpression;", "visitCallExpression", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "visitContinueExpression", "Lorg/jetbrains/kotlin/psi/KtContinueExpression;", "visitIfExpression", "Lorg/jetbrains/kotlin/psi/KtIfExpression;", "visitLoopExpression", "loopExpression", "Lorg/jetbrains/kotlin/psi/KtLoopExpression;", "visitNamedFunction", "visitTryExpression", "Lorg/jetbrains/kotlin/psi/KtTryExpression;", "visitWhenExpression", "Lorg/jetbrains/kotlin/psi/KtWhenExpression;", "extractEntries", "Lkotlin/sequences/Sequence;", "Lorg/jetbrains/kotlin/psi/KtWhenEntry;", "isUsedForNesting", "Companion", "Config", "detekt-api"})
public final class CyclomaticComplexity
extends DetektVisitor {
    private int complexity;
    private final Config config;
    @NotNull
    private static final Set<KtSingleValueToken> CONDITIONALS;
    @NotNull
    private static final Set<String> DEFAULT_NESTING_FUNCTIONS;
    public static final Companion Companion;

    public final int getComplexity() {
        return this.complexity;
    }

    public void visitNamedFunction(@NotNull KtNamedFunction function) {
        Intrinsics.checkParameterIsNotNull((Object)function, (String)"function");
        if (!this.isInsideObjectLiteral(function)) {
            int n = this.complexity;
            this.complexity = n + 1;
            super.visitNamedFunction(function);
        }
    }

    private final boolean isInsideObjectLiteral(KtNamedFunction function) {
        PsiElement $this$getStrictParentOfType$iv = (PsiElement)function;
        boolean $i$f$getStrictParentOfType = false;
        return PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtObjectLiteralExpression.class, (boolean)true) != null;
    }

    public void visitBinaryExpression(@NotNull KtBinaryExpression expression) {
        Intrinsics.checkParameterIsNotNull((Object)expression, (String)"expression");
        if (CollectionsKt.contains((Iterable)CONDITIONALS, (Object)expression.getOperationToken())) {
            int n = this.complexity;
            this.complexity = n + 1;
        }
        super.visitBinaryExpression(expression);
    }

    public void visitContinueExpression(@NotNull KtContinueExpression expression) {
        Intrinsics.checkParameterIsNotNull((Object)expression, (String)"expression");
        int n = this.complexity;
        this.complexity = n + 1;
        super.visitContinueExpression(expression);
    }

    public void visitBreakExpression(@NotNull KtBreakExpression expression) {
        Intrinsics.checkParameterIsNotNull((Object)expression, (String)"expression");
        int n = this.complexity;
        this.complexity = n + 1;
        super.visitBreakExpression(expression);
    }

    public void visitIfExpression(@NotNull KtIfExpression expression) {
        Intrinsics.checkParameterIsNotNull((Object)expression, (String)"expression");
        int n = this.complexity;
        this.complexity = n + 1;
        super.visitIfExpression(expression);
    }

    public void visitLoopExpression(@NotNull KtLoopExpression loopExpression) {
        Intrinsics.checkParameterIsNotNull((Object)loopExpression, (String)"loopExpression");
        int n = this.complexity;
        this.complexity = n + 1;
        super.visitLoopExpression(loopExpression);
    }

    public void visitWhenExpression(@NotNull KtWhenExpression expression) {
        Intrinsics.checkParameterIsNotNull((Object)expression, (String)"expression");
        Sequence<KtWhenEntry> entries = this.extractEntries(expression);
        this.complexity += this.config.getIgnoreSimpleWhenEntries() && SequencesKt.count(entries) == 0 ? 1 : SequencesKt.count(entries);
        super.visitWhenExpression(expression);
    }

    private final Sequence<KtWhenEntry> extractEntries(@NotNull KtWhenExpression $this$extractEntries) {
        List list = $this$extractEntries.getEntries();
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"entries");
        Sequence entries = CollectionsKt.asSequence((Iterable)list);
        return this.config.getIgnoreSimpleWhenEntries() ? SequencesKt.filter((Sequence)entries, (Function1)extractEntries.1.INSTANCE) : entries;
    }

    public void visitTryExpression(@NotNull KtTryExpression expression) {
        Intrinsics.checkParameterIsNotNull((Object)expression, (String)"expression");
        this.complexity += expression.getCatchClauses().size();
        super.visitTryExpression(expression);
    }

    private final boolean isUsedForNesting(@NotNull KtCallExpression $this$isUsedForNesting) {
        KtSimpleNameExpression ktSimpleNameExpression = KtPsiUtilKt.getCallNameExpression((KtCallElement)((KtCallElement)$this$isUsedForNesting));
        String string = ktSimpleNameExpression != null ? ktSimpleNameExpression.getText() : null;
        return CollectionsKt.contains((Iterable)this.config.getNestingFunctions(), (Object)string);
    }

    public void visitCallExpression(@NotNull KtCallExpression expression) {
        Intrinsics.checkParameterIsNotNull((Object)expression, (String)"expression");
        if (!this.config.getIgnoreNestingFunctions() && this.isUsedForNesting(expression)) {
            List list = expression.getLambdaArguments();
            Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"expression.lambdaArguments");
            KtLambdaArgument ktLambdaArgument = (KtLambdaArgument)CollectionsKt.firstOrNull((List)list);
            Object lambdaExpression = ktLambdaArgument != null ? ktLambdaArgument.getLambdaExpression() : null;
            KtLambdaExpression ktLambdaExpression = lambdaExpression;
            if (ktLambdaExpression != null && (ktLambdaExpression = ktLambdaExpression.getBodyExpression()) != null) {
                KtLambdaExpression ktLambdaExpression2 = ktLambdaExpression;
                boolean bl = false;
                boolean bl2 = false;
                KtLambdaExpression it = ktLambdaExpression2;
                boolean bl3 = false;
                int n = this.complexity;
                this.complexity = n + 1;
            }
        }
        super.visitCallExpression(expression);
    }

    public CyclomaticComplexity(@NotNull Config config) {
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        this.config = config;
    }

    static {
        Companion = new Companion(null);
        CONDITIONALS = SetsKt.setOf((Object[])new KtSingleValueToken[]{KtTokens.ELVIS, KtTokens.ANDAND, KtTokens.OROR});
        DEFAULT_NESTING_FUNCTIONS = SetsKt.setOf((Object[])new String[]{"run", "let", "apply", "with", "also", "use", "forEach", "isNotNull", "ifNull"});
    }

    public static final /* synthetic */ int access$getComplexity$p(CyclomaticComplexity $this) {
        return $this.complexity;
    }

    public static final /* synthetic */ void access$setComplexity$p(CyclomaticComplexity $this, int n) {
        $this.complexity = n;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0012\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B)\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\u0010\bJ\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u00c6\u0003J-\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u00c6\u0001J\u0013\u0010\u0017\u001a\u00020\u00032\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001J\t\u0010\u001b\u001a\u00020\u0007H\u00d6\u0001R\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\n\"\u0004\b\u000e\u0010\fR \u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001c"}, d2={"Lio/gitlab/arturbosch/detekt/api/internal/CyclomaticComplexity$Config;", "", "ignoreSimpleWhenEntries", "", "ignoreNestingFunctions", "nestingFunctions", "", "", "(ZZLjava/util/Set;)V", "getIgnoreNestingFunctions", "()Z", "setIgnoreNestingFunctions", "(Z)V", "getIgnoreSimpleWhenEntries", "setIgnoreSimpleWhenEntries", "getNestingFunctions", "()Ljava/util/Set;", "setNestingFunctions", "(Ljava/util/Set;)V", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "", "toString", "detekt-api"})
    public static final class Config {
        private boolean ignoreSimpleWhenEntries;
        private boolean ignoreNestingFunctions;
        @NotNull
        private Set<String> nestingFunctions;

        public final boolean getIgnoreSimpleWhenEntries() {
            return this.ignoreSimpleWhenEntries;
        }

        public final void setIgnoreSimpleWhenEntries(boolean bl) {
            this.ignoreSimpleWhenEntries = bl;
        }

        public final boolean getIgnoreNestingFunctions() {
            return this.ignoreNestingFunctions;
        }

        public final void setIgnoreNestingFunctions(boolean bl) {
            this.ignoreNestingFunctions = bl;
        }

        @NotNull
        public final Set<String> getNestingFunctions() {
            return this.nestingFunctions;
        }

        public final void setNestingFunctions(@NotNull Set<String> set) {
            Intrinsics.checkParameterIsNotNull(set, (String)"<set-?>");
            this.nestingFunctions = set;
        }

        public Config(boolean ignoreSimpleWhenEntries, boolean ignoreNestingFunctions, @NotNull Set<String> nestingFunctions) {
            Intrinsics.checkParameterIsNotNull(nestingFunctions, (String)"nestingFunctions");
            this.ignoreSimpleWhenEntries = ignoreSimpleWhenEntries;
            this.ignoreNestingFunctions = ignoreNestingFunctions;
            this.nestingFunctions = nestingFunctions;
        }

        public /* synthetic */ Config(boolean bl, boolean bl2, Set set, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                bl = false;
            }
            if ((n & 2) != 0) {
                bl2 = false;
            }
            if ((n & 4) != 0) {
                set = Companion.getDEFAULT_NESTING_FUNCTIONS();
            }
            this(bl, bl2, set);
        }

        public Config() {
            this(false, false, null, 7, null);
        }

        public final boolean component1() {
            return this.ignoreSimpleWhenEntries;
        }

        public final boolean component2() {
            return this.ignoreNestingFunctions;
        }

        @NotNull
        public final Set<String> component3() {
            return this.nestingFunctions;
        }

        @NotNull
        public final Config copy(boolean ignoreSimpleWhenEntries, boolean ignoreNestingFunctions, @NotNull Set<String> nestingFunctions) {
            Intrinsics.checkParameterIsNotNull(nestingFunctions, (String)"nestingFunctions");
            return new Config(ignoreSimpleWhenEntries, ignoreNestingFunctions, nestingFunctions);
        }

        public static /* synthetic */ Config copy$default(Config config, boolean bl, boolean bl2, Set set, int n, Object object) {
            if ((n & 1) != 0) {
                bl = config.ignoreSimpleWhenEntries;
            }
            if ((n & 2) != 0) {
                bl2 = config.ignoreNestingFunctions;
            }
            if ((n & 4) != 0) {
                set = config.nestingFunctions;
            }
            return config.copy(bl, bl2, set);
        }

        @NotNull
        public String toString() {
            return "Config(ignoreSimpleWhenEntries=" + this.ignoreSimpleWhenEntries + ", ignoreNestingFunctions=" + this.ignoreNestingFunctions + ", nestingFunctions=" + this.nestingFunctions + ")";
        }

        public int hashCode() {
            int n = this.ignoreSimpleWhenEntries ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            int n2 = n * 31;
            int n3 = this.ignoreNestingFunctions ? 1 : 0;
            if (n3 != 0) {
                n3 = 1;
            }
            Set<String> set = this.nestingFunctions;
            return (n2 + n3) * 31 + (set != null ? ((Object)set).hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Config)) break block3;
                    Config config = (Config)object;
                    if (this.ignoreSimpleWhenEntries != config.ignoreSimpleWhenEntries || this.ignoreNestingFunctions != config.ignoreNestingFunctions || !Intrinsics.areEqual(this.nestingFunctions, config.nestingFunctions)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J+\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u001b\b\u0002\u0010\u0010\u001a\u0015\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u0011\u00a2\u0006\u0002\b\u0014R\u001f\u0010\u0003\u001a\u0010\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\b\u00a8\u0006\u0015"}, d2={"Lio/gitlab/arturbosch/detekt/api/internal/CyclomaticComplexity$Companion;", "", "()V", "CONDITIONALS", "", "Lorg/jetbrains/kotlin/lexer/KtSingleValueToken;", "kotlin.jvm.PlatformType", "getCONDITIONALS", "()Ljava/util/Set;", "DEFAULT_NESTING_FUNCTIONS", "", "getDEFAULT_NESTING_FUNCTIONS", "calculate", "", "node", "Lorg/jetbrains/kotlin/psi/KtElement;", "configure", "Lkotlin/Function1;", "Lio/gitlab/arturbosch/detekt/api/internal/CyclomaticComplexity$Config;", "", "Lkotlin/ExtensionFunctionType;", "detekt-api"})
    public static final class Companion {
        @NotNull
        public final Set<KtSingleValueToken> getCONDITIONALS() {
            return CONDITIONALS;
        }

        @NotNull
        public final Set<String> getDEFAULT_NESTING_FUNCTIONS() {
            return DEFAULT_NESTING_FUNCTIONS;
        }

        public final int calculate(@NotNull KtElement node, @Nullable Function1<? super Config, Unit> configure) {
            Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
            Config config = new Config(false, false, null, 7, null);
            Function1<? super Config, Unit> function1 = configure;
            if (function1 != null) {
                Unit cfr_ignored_0 = (Unit)function1.invoke((Object)config);
            }
            CyclomaticComplexity visitor = new CyclomaticComplexity(config);
            node.accept((PsiElementVisitor)visitor);
            return visitor.getComplexity();
        }

        public static /* synthetic */ int calculate$default(Companion companion, KtElement ktElement, Function1 function1, int n, Object object) {
            if ((n & 2) != 0) {
                function1 = null;
            }
            return companion.calculate(ktElement, (Function1<? super Config, Unit>)function1);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

