/*
 * Decompiled with CFR 0.152.
 */
package io.github.detekt.psi;

import io.github.detekt.psi.KeysKt;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000\u001a\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\n\u0010\u0007\u001a\u00020\b*\u00020\u0004\u001a\n\u0010\t\u001a\u00020\u0001*\u00020\u0004\u001a\n\u0010\n\u001a\u00020\b*\u00020\u0004\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u0015\u0010\u0003\u001a\u00020\u0001*\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000b"}, d2={"KOTLIN_SCRIPT_SUFFIX", "", "KOTLIN_SUFFIX", "fileName", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiFile;", "getFileName", "(Lorg/jetbrains/kotlin/com/intellij/psi/PsiFile;)Ljava/lang/String;", "absolutePath", "Ljava/nio/file/Path;", "fileNameWithoutSuffix", "relativePath", "detekt-psi-utils"})
public final class KtFilesKt {
    @NotNull
    public static final String KOTLIN_SUFFIX = ".kt";
    @NotNull
    public static final String KOTLIN_SCRIPT_SUFFIX = ".kts";

    @NotNull
    public static final String getFileName(@NotNull PsiFile $this$fileName) {
        Intrinsics.checkNotNullParameter((Object)$this$fileName, (String)"$this$fileName");
        String string = $this$fileName.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name");
        return StringsKt.substringAfterLast$default((String)string, (char)File.separatorChar, null, (int)2, null);
    }

    @NotNull
    public static final String fileNameWithoutSuffix(@NotNull PsiFile $this$fileNameWithoutSuffix) {
        Intrinsics.checkNotNullParameter((Object)$this$fileNameWithoutSuffix, (String)"$this$fileNameWithoutSuffix");
        String fileName = KtFilesKt.getFileName($this$fileNameWithoutSuffix);
        if (StringsKt.endsWith$default((String)fileName, (String)KOTLIN_SCRIPT_SUFFIX, (boolean)false, (int)2, null)) {
            return StringsKt.removeSuffix((String)fileName, (CharSequence)KOTLIN_SCRIPT_SUFFIX);
        }
        return StringsKt.removeSuffix((String)fileName, (CharSequence)KOTLIN_SUFFIX);
    }

    @NotNull
    public static final Path absolutePath(@NotNull PsiFile $this$absolutePath) {
        Intrinsics.checkNotNullParameter((Object)$this$absolutePath, (String)"$this$absolutePath");
        Path path = Paths.get($this$absolutePath.getName(), new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"Paths.get(name)");
        return path;
    }

    @NotNull
    public static final Path relativePath(@NotNull PsiFile $this$relativePath) {
        Intrinsics.checkNotNullParameter((Object)$this$relativePath, (String)"$this$relativePath");
        String value = (String)$this$relativePath.getUserData(KeysKt.getRELATIVE_PATH());
        boolean bl = false;
        boolean bl2 = false;
        if (value == null) {
            boolean bl3 = false;
            String string = "KtFile '" + $this$relativePath.getName() + "' expected to have an relative path.";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        Path path = Paths.get(value, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"Paths.get(value)");
        return path;
    }
}

