/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules;

import io.gitlab.arturbosch.detekt.rules.KtAnnotatedExtensionsKt;
import io.gitlab.arturbosch.detekt.rules.KtModifierListKt;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.psi.KtAnnotated;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtTypeReference;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000\u001e\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u001a\n\u0010\u0003\u001a\u00020\u0004*\u00020\u0005\u001a\f\u0010\u0006\u001a\u00020\u0004*\u00020\u0007H\u0002\u001a\f\u0010\b\u001a\u00020\u0004*\u00020\u0007H\u0002\u001a\n\u0010\t\u001a\u00020\u0004*\u00020\u0005\u001a\n\u0010\n\u001a\u00020\u0004*\u00020\u0005\u001a\n\u0010\u000b\u001a\u00020\u0004*\u00020\u0007\u001a\f\u0010\f\u001a\u00020\u0004*\u00020\u0007H\u0002\"\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"knownAnys", "", "", "hasCorrectEqualsParameter", "", "Lorg/jetbrains/kotlin/psi/KtFunction;", "hasMainParameter", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "hasMainSignature", "isEqualsFunction", "isHashCodeFunction", "isMainFunction", "isMainInsideObject", "detekt-psi-utils"})
public final class MethodSignatureKt {
    private static final Set<String> knownAnys = SetsKt.setOf((Object[])new String[]{"Any?", "kotlin.Any?"});

    public static final boolean isEqualsFunction(@NotNull KtFunction $this$isEqualsFunction) {
        Intrinsics.checkNotNullParameter((Object)$this$isEqualsFunction, (String)"$this$isEqualsFunction");
        return Intrinsics.areEqual((Object)$this$isEqualsFunction.getName(), (Object)"equals") && KtModifierListKt.isOverride((KtModifierListOwner)$this$isEqualsFunction) && MethodSignatureKt.hasCorrectEqualsParameter($this$isEqualsFunction);
    }

    public static final boolean isHashCodeFunction(@NotNull KtFunction $this$isHashCodeFunction) {
        Intrinsics.checkNotNullParameter((Object)$this$isHashCodeFunction, (String)"$this$isHashCodeFunction");
        return Intrinsics.areEqual((Object)$this$isHashCodeFunction.getName(), (Object)"hashCode") && KtModifierListKt.isOverride((KtModifierListOwner)$this$isHashCodeFunction) && $this$isHashCodeFunction.getValueParameters().isEmpty();
    }

    public static final boolean hasCorrectEqualsParameter(@NotNull KtFunction $this$hasCorrectEqualsParameter) {
        Intrinsics.checkNotNullParameter((Object)$this$hasCorrectEqualsParameter, (String)"$this$hasCorrectEqualsParameter");
        Iterable iterable = knownAnys;
        List list = $this$hasCorrectEqualsParameter.getValueParameters();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"this.valueParameters");
        KtParameter ktParameter = (KtParameter)CollectionsKt.singleOrNull((List)list);
        return CollectionsKt.contains((Iterable)iterable, ktParameter != null && (ktParameter = ktParameter.getTypeReference()) != null ? ktParameter.getText() : null);
    }

    public static final boolean isMainFunction(@NotNull KtNamedFunction $this$isMainFunction) {
        Intrinsics.checkNotNullParameter((Object)$this$isMainFunction, (String)"$this$isMainFunction");
        return MethodSignatureKt.hasMainSignature($this$isMainFunction) && ($this$isMainFunction.isTopLevel() || MethodSignatureKt.isMainInsideObject($this$isMainFunction));
    }

    private static final boolean hasMainSignature(KtNamedFunction $this$hasMainSignature) {
        return Intrinsics.areEqual((Object)$this$hasMainSignature.getName(), (Object)"main") && KtModifierListKt.isPublicNotOverridden((KtModifierListOwner)$this$hasMainSignature) && MethodSignatureKt.hasMainParameter($this$hasMainSignature);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean hasMainParameter(KtNamedFunction $this$hasMainParameter) {
        if ($this$hasMainParameter.getValueParameters().isEmpty()) return true;
        if ($this$hasMainParameter.getValueParameters().size() != 1) return false;
        Object e = $this$hasMainParameter.getValueParameters().get(0);
        Intrinsics.checkNotNullExpressionValue(e, (String)"valueParameters[0]");
        KtTypeReference ktTypeReference = ((KtParameter)e).getTypeReference();
        if (!Intrinsics.areEqual((Object)(ktTypeReference != null ? ktTypeReference.getText() : null), (Object)"Array<String>")) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isMainInsideObject(KtNamedFunction $this$isMainInsideObject) {
        if (!Intrinsics.areEqual((Object)$this$isMainInsideObject.getName(), (Object)"main")) return false;
        if (!KtModifierListKt.isPublicNotOverridden((KtModifierListOwner)$this$isMainInsideObject)) return false;
        PsiElement psiElement = $this$isMainInsideObject.getParent();
        if (!((psiElement != null ? psiElement.getParent() : null) instanceof KtObjectDeclaration)) return false;
        if (!KtAnnotatedExtensionsKt.hasAnnotation((KtAnnotated)$this$isMainInsideObject, "JvmStatic", "kotlin.jvm.JvmStatic")) return false;
        return true;
    }
}

