/*
 * Decompiled with CFR 0.152.
 */
package io.github.detekt.psi;

import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\f\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\r\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J+\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u0017"}, d2={"Lio/github/detekt/psi/FilePath;", "", "absolutePath", "Ljava/nio/file/Path;", "basePath", "relativePath", "(Ljava/nio/file/Path;Ljava/nio/file/Path;Ljava/nio/file/Path;)V", "getAbsolutePath", "()Ljava/nio/file/Path;", "getBasePath", "getRelativePath", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "Companion", "detekt-psi-utils"})
public final class FilePath {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Path absolutePath;
    @Nullable
    private final Path basePath;
    @Nullable
    private final Path relativePath;

    public FilePath(@NotNull Path absolutePath, @Nullable Path basePath, @Nullable Path relativePath) {
        Intrinsics.checkNotNullParameter((Object)absolutePath, (String)"absolutePath");
        this.absolutePath = absolutePath;
        this.basePath = basePath;
        this.relativePath = relativePath;
        boolean bl = this.basePath == null || this.relativePath == null || Intrinsics.areEqual((Object)this.absolutePath, (Object)this.basePath.resolve(this.relativePath).normalize());
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Absolute path = " + this.getAbsolutePath() + " much match base path = " + this.getBasePath() + " and relative path = " + this.getRelativePath();
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
    }

    public /* synthetic */ FilePath(Path path, Path path2, Path path3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            path2 = null;
        }
        if ((n & 4) != 0) {
            path3 = null;
        }
        this(path, path2, path3);
    }

    @NotNull
    public final Path getAbsolutePath() {
        return this.absolutePath;
    }

    @Nullable
    public final Path getBasePath() {
        return this.basePath;
    }

    @Nullable
    public final Path getRelativePath() {
        return this.relativePath;
    }

    @NotNull
    public final Path component1() {
        return this.absolutePath;
    }

    @Nullable
    public final Path component2() {
        return this.basePath;
    }

    @Nullable
    public final Path component3() {
        return this.relativePath;
    }

    @NotNull
    public final FilePath copy(@NotNull Path absolutePath, @Nullable Path basePath, @Nullable Path relativePath) {
        Intrinsics.checkNotNullParameter((Object)absolutePath, (String)"absolutePath");
        return new FilePath(absolutePath, basePath, relativePath);
    }

    public static /* synthetic */ FilePath copy$default(FilePath filePath, Path path, Path path2, Path path3, int n, Object object) {
        if ((n & 1) != 0) {
            path = filePath.absolutePath;
        }
        if ((n & 2) != 0) {
            path2 = filePath.basePath;
        }
        if ((n & 4) != 0) {
            path3 = filePath.relativePath;
        }
        return filePath.copy(path, path2, path3);
    }

    @NotNull
    public String toString() {
        return "FilePath(absolutePath=" + this.absolutePath + ", basePath=" + this.basePath + ", relativePath=" + this.relativePath + ')';
    }

    public int hashCode() {
        int result = ((Object)this.absolutePath).hashCode();
        result = result * 31 + (this.basePath == null ? 0 : ((Object)this.basePath).hashCode());
        result = result * 31 + (this.relativePath == null ? 0 : ((Object)this.relativePath).hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof FilePath)) {
            return false;
        }
        FilePath filePath = (FilePath)other;
        if (!Intrinsics.areEqual((Object)this.absolutePath, (Object)filePath.absolutePath)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.basePath, (Object)filePath.basePath)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.relativePath, (Object)filePath.relativePath);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0016\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0006\u00a8\u0006\n"}, d2={"Lio/github/detekt/psi/FilePath$Companion;", "", "()V", "fromAbsolute", "Lio/github/detekt/psi/FilePath;", "path", "Ljava/nio/file/Path;", "fromRelative", "basePath", "relativePath", "detekt-psi-utils"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final FilePath fromAbsolute(@NotNull Path path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Path path2 = path.normalize();
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"path.normalize()");
            return new FilePath(path2, null, null, 6, null);
        }

        @NotNull
        public final FilePath fromRelative(@NotNull Path basePath, @NotNull Path relativePath) {
            Intrinsics.checkNotNullParameter((Object)basePath, (String)"basePath");
            Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
            Path path = basePath.resolve(relativePath).normalize();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"basePath.resolve(relativePath).normalize()");
            return new FilePath(path, basePath.normalize(), relativePath);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

