/*
 * Decompiled with CFR 0.152.
 */
package io.github.detekt.psi;

import io.github.detekt.psi.FilePath;
import io.github.detekt.psi.KeysKt;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\n\u0010\u0007\u001a\u00020\b*\u00020\u0004\u001a\f\u0010\t\u001a\u0004\u0018\u00010\b*\u00020\u0004\u001a\n\u0010\n\u001a\u00020\u0001*\u00020\u0004\u001a\f\u0010\u000b\u001a\u0004\u0018\u00010\b*\u00020\u0004\u001a\n\u0010\f\u001a\u00020\r*\u00020\u0004\u001a\n\u0010\u000e\u001a\u00020\u0001*\u00020\b\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u0015\u0010\u0003\u001a\u00020\u0001*\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000f"}, d2={"KOTLIN_SCRIPT_SUFFIX", "", "KOTLIN_SUFFIX", "fileName", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiFile;", "getFileName", "(Lorg/jetbrains/kotlin/com/intellij/psi/PsiFile;)Ljava/lang/String;", "absolutePath", "Ljava/nio/file/Path;", "basePath", "fileNameWithoutSuffix", "relativePath", "toFilePath", "Lio/github/detekt/psi/FilePath;", "toUnifiedString", "detekt-psi-utils"})
public final class KtFilesKt {
    @NotNull
    public static final String KOTLIN_SUFFIX = ".kt";
    @NotNull
    public static final String KOTLIN_SCRIPT_SUFFIX = ".kts";

    @NotNull
    public static final String getFileName(@NotNull PsiFile $this$fileName) {
        Intrinsics.checkNotNullParameter((Object)$this$fileName, (String)"<this>");
        String string = $this$fileName.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name");
        return StringsKt.substringAfterLast$default((String)string, (char)File.separatorChar, null, (int)2, null);
    }

    @NotNull
    public static final String fileNameWithoutSuffix(@NotNull PsiFile $this$fileNameWithoutSuffix) {
        Intrinsics.checkNotNullParameter((Object)$this$fileNameWithoutSuffix, (String)"<this>");
        String fileName = KtFilesKt.getFileName($this$fileNameWithoutSuffix);
        if (StringsKt.endsWith$default((String)fileName, (String)KOTLIN_SCRIPT_SUFFIX, (boolean)false, (int)2, null)) {
            return StringsKt.removeSuffix((String)fileName, (CharSequence)KOTLIN_SCRIPT_SUFFIX);
        }
        return StringsKt.removeSuffix((String)fileName, (CharSequence)KOTLIN_SUFFIX);
    }

    @NotNull
    public static final Path absolutePath(@NotNull PsiFile $this$absolutePath) {
        Intrinsics.checkNotNullParameter((Object)$this$absolutePath, (String)"<this>");
        Path path = Paths.get($this$absolutePath.getName(), new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(name)");
        return path;
    }

    @Nullable
    public static final Path relativePath(@NotNull PsiFile $this$relativePath) {
        Path path;
        Intrinsics.checkNotNullParameter((Object)$this$relativePath, (String)"<this>");
        String string = (String)$this$relativePath.getUserData(KeysKt.getRELATIVE_PATH());
        if (string == null) {
            path = null;
        } else {
            String string2 = string;
            boolean bl = false;
            boolean bl2 = false;
            String it = string2;
            boolean bl3 = false;
            path = Paths.get(it, new String[0]);
        }
        return path;
    }

    @Nullable
    public static final Path basePath(@NotNull PsiFile $this$basePath) {
        Path path;
        Intrinsics.checkNotNullParameter((Object)$this$basePath, (String)"<this>");
        String string = (String)$this$basePath.getUserData(KeysKt.getBASE_PATH());
        if (string == null) {
            path = null;
        } else {
            String string2 = string;
            boolean bl = false;
            boolean bl2 = false;
            String it = string2;
            boolean bl3 = false;
            path = Paths.get(it, new String[0]);
        }
        return path;
    }

    @NotNull
    public static final FilePath toFilePath(@NotNull PsiFile $this$toFilePath) {
        FilePath filePath;
        Intrinsics.checkNotNullParameter((Object)$this$toFilePath, (String)"<this>");
        Path relativePath = KtFilesKt.relativePath($this$toFilePath);
        Path basePath = KtFilesKt.basePath($this$toFilePath);
        if (basePath != null && relativePath != null) {
            filePath = new FilePath(KtFilesKt.absolutePath($this$toFilePath), basePath, relativePath);
        } else if (basePath == null && relativePath == null) {
            filePath = new FilePath(KtFilesKt.absolutePath($this$toFilePath), null, null, 6, null);
        } else {
            String string = "Cannot build a FilePath from base path = " + basePath + " and relative path = " + relativePath;
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return filePath;
    }

    @NotNull
    public static final String toUnifiedString(@NotNull Path $this$toUnifiedString) {
        Intrinsics.checkNotNullParameter((Object)$this$toUnifiedString, (String)"<this>");
        return StringsKt.replace$default((String)((Object)$this$toUnifiedString).toString(), (char)File.separatorChar, (char)'/', (boolean)false, (int)4, null);
    }
}

