/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.complexity;

import io.github.detekt.metrics.CyclomaticComplexity;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.ConfigPropertyKt;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Metric;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.ThresholdedCodeSmell;
import io.gitlab.arturbosch.detekt.api.internal.Configuration;
import io.gitlab.arturbosch.detekt.rules.complexity.CyclomaticComplexMethod;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtReturnExpression;
import org.jetbrains.kotlin.psi.KtWhenExpression;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 02\u00020\u0001:\u00010B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010(\u001a\u00020\u000b2\b\u0010)\u001a\u0004\u0018\u00010*H\u0002J\u0010\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.H\u0016J\f\u0010/\u001a\u00020\u000b*\u00020*H\u0002R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR!\u0010\n\u001a\u00020\u000b8BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u0010\u0010\u0011\u0012\u0004\b\f\u0010\r\u001a\u0004\b\u000e\u0010\u000fR!\u0010\u0012\u001a\u00020\u000b8BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u0015\u0010\u0011\u0012\u0004\b\u0013\u0010\r\u001a\u0004\b\u0014\u0010\u000fR!\u0010\u0016\u001a\u00020\u000b8BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u0019\u0010\u0011\u0012\u0004\b\u0017\u0010\r\u001a\u0004\b\u0018\u0010\u000fR\u0014\u0010\u001a\u001a\u00020\u001bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR'\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b!\u0010\u0011\u0012\u0004\b\u001f\u0010\r\u001a\u0004\b \u0010\tR!\u0010\"\u001a\u00020#8BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b'\u0010\u0011\u0012\u0004\b$\u0010\r\u001a\u0004\b%\u0010&\u00a8\u00061"}, d2={"Lio/gitlab/arturbosch/detekt/rules/complexity/CyclomaticComplexMethod;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "defaultRuleIdAliases", "", "", "getDefaultRuleIdAliases", "()Ljava/util/Set;", "ignoreNestingFunctions", "", "getIgnoreNestingFunctions$annotations", "()V", "getIgnoreNestingFunctions", "()Z", "ignoreNestingFunctions$delegate", "Lkotlin/properties/ReadOnlyProperty;", "ignoreSimpleWhenEntries", "getIgnoreSimpleWhenEntries$annotations", "getIgnoreSimpleWhenEntries", "ignoreSimpleWhenEntries$delegate", "ignoreSingleWhenExpression", "getIgnoreSingleWhenExpression$annotations", "getIgnoreSingleWhenExpression", "ignoreSingleWhenExpression$delegate", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "nestingFunctions", "getNestingFunctions$annotations", "getNestingFunctions", "nestingFunctions$delegate", "threshold", "", "getThreshold$annotations", "getThreshold", "()I", "threshold$delegate", "hasSingleWhenExpression", "bodyExpression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "visitNamedFunction", "", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "returnsWhenExpression", "Companion", "detekt-rules-complexity"})
public final class CyclomaticComplexMethod
extends Rule {
    @NotNull
    public static final Companion Companion;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final Issue issue;
    @NotNull
    private final Set<String> defaultRuleIdAliases;
    @NotNull
    private final ReadOnlyProperty threshold$delegate;
    @NotNull
    private final ReadOnlyProperty ignoreSingleWhenExpression$delegate;
    @NotNull
    private final ReadOnlyProperty ignoreSimpleWhenEntries$delegate;
    @NotNull
    private final ReadOnlyProperty ignoreNestingFunctions$delegate;
    @NotNull
    private final ReadOnlyProperty nestingFunctions$delegate;
    @NotNull
    private static final List<String> DEFAULT_NESTING_FUNCTIONS;

    public CyclomaticComplexMethod(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        this.issue = new Issue("CyclomaticComplexMethod", Severity.Maintainability, "Prefer splitting up complex methods into smaller, easier to test methods.", Debt.Companion.getTWENTY_MINS());
        this.defaultRuleIdAliases = SetsKt.setOf((Object)"ComplexMethod");
        this.threshold$delegate = ConfigPropertyKt.config((Object)15);
        this.ignoreSingleWhenExpression$delegate = ConfigPropertyKt.config((Object)false);
        this.ignoreSimpleWhenEntries$delegate = ConfigPropertyKt.config((Object)false);
        this.ignoreNestingFunctions$delegate = ConfigPropertyKt.config((Object)false);
        this.nestingFunctions$delegate = ConfigPropertyKt.config(DEFAULT_NESTING_FUNCTIONS, (Function1)nestingFunctions.2.INSTANCE);
    }

    public /* synthetic */ CyclomaticComplexMethod(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    @NotNull
    public Set<String> getDefaultRuleIdAliases() {
        return this.defaultRuleIdAliases;
    }

    private final int getThreshold() {
        return ((Number)this.threshold$delegate.getValue((Object)this, $$delegatedProperties[0])).intValue();
    }

    @Configuration(description="McCabe's Cyclomatic Complexity (MCC) number for a method.")
    private static /* synthetic */ void getThreshold$annotations() {
    }

    private final boolean getIgnoreSingleWhenExpression() {
        return (Boolean)this.ignoreSingleWhenExpression$delegate.getValue((Object)this, $$delegatedProperties[1]);
    }

    @Configuration(description="Ignores a complex method if it only contains a single when expression.")
    private static /* synthetic */ void getIgnoreSingleWhenExpression$annotations() {
    }

    private final boolean getIgnoreSimpleWhenEntries() {
        return (Boolean)this.ignoreSimpleWhenEntries$delegate.getValue((Object)this, $$delegatedProperties[2]);
    }

    @Configuration(description="Whether to ignore simple (braceless) when entries.")
    private static /* synthetic */ void getIgnoreSimpleWhenEntries$annotations() {
    }

    private final boolean getIgnoreNestingFunctions() {
        return (Boolean)this.ignoreNestingFunctions$delegate.getValue((Object)this, $$delegatedProperties[3]);
    }

    @Configuration(description="Whether to ignore functions which are often used instead of an `if` or `for` statement.")
    private static /* synthetic */ void getIgnoreNestingFunctions$annotations() {
    }

    private final Set<String> getNestingFunctions() {
        return (Set)this.nestingFunctions$delegate.getValue((Object)this, $$delegatedProperties[4]);
    }

    @Configuration(description="Comma separated list of function names which add complexity.")
    private static /* synthetic */ void getNestingFunctions$annotations() {
    }

    public void visitNamedFunction(@NotNull KtNamedFunction function) {
        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
        if (this.getIgnoreSingleWhenExpression() && this.hasSingleWhenExpression(function.getBodyExpression())) {
            return;
        }
        int complexity2 = CyclomaticComplexity.Companion.calculate((KtElement)function, (Function1)new Function1<CyclomaticComplexity.Config, Unit>(this){
            final /* synthetic */ CyclomaticComplexMethod this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull CyclomaticComplexity.Config $this$calculate) {
                Intrinsics.checkNotNullParameter((Object)$this$calculate, (String)"$this$calculate");
                $this$calculate.setIgnoreSimpleWhenEntries(CyclomaticComplexMethod.access$getIgnoreSimpleWhenEntries(this.this$0));
                $this$calculate.setIgnoreNestingFunctions(CyclomaticComplexMethod.access$getIgnoreNestingFunctions(this.this$0));
                $this$calculate.setNestingFunctions(CyclomaticComplexMethod.access$getNestingFunctions(this.this$0));
            }
        });
        if (complexity2 >= this.getThreshold()) {
            this.report((Finding)new ThresholdedCodeSmell(this.getIssue(), Entity.Companion.atName((KtNamedDeclaration)function), new Metric("MCC", complexity2, this.getThreshold(), false, 0, 24, null), "The function " + function.getNameAsSafeName() + " appears to be too complex based on Cyclomatic Complexity (complexity: " + complexity2 + "). Defined complexity threshold for methods is set to '" + this.getThreshold() + '\'', null, 16, null));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean hasSingleWhenExpression(KtExpression bodyExpression) {
        if (bodyExpression instanceof KtBlockExpression && ((KtBlockExpression)bodyExpression).getStatements().size() == 1) {
            List list = ((KtBlockExpression)bodyExpression).getStatements();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"bodyExpression.statements");
            KtExpression statement = (KtExpression)CollectionsKt.single((List)list);
            if (statement instanceof KtWhenExpression) return true;
            Intrinsics.checkNotNullExpressionValue((Object)statement, (String)"statement");
            if (!this.returnsWhenExpression(statement)) return false;
            return true;
        }
        if (!(bodyExpression instanceof KtWhenExpression)) return false;
        return true;
    }

    private final boolean returnsWhenExpression(KtExpression $this$returnsWhenExpression) {
        return $this$returnsWhenExpression instanceof KtReturnExpression && ((KtReturnExpression)$this$returnsWhenExpression).getReturnedExpression() instanceof KtWhenExpression;
    }

    public CyclomaticComplexMethod() {
        this(null, 1, null);
    }

    public static final /* synthetic */ boolean access$getIgnoreSimpleWhenEntries(CyclomaticComplexMethod $this) {
        return $this.getIgnoreSimpleWhenEntries();
    }

    public static final /* synthetic */ boolean access$getIgnoreNestingFunctions(CyclomaticComplexMethod $this) {
        return $this.getIgnoreNestingFunctions();
    }

    public static final /* synthetic */ Set access$getNestingFunctions(CyclomaticComplexMethod $this) {
        return $this.getNestingFunctions();
    }

    static {
        Object[] objectArray = new KProperty[]{Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(CyclomaticComplexMethod.class, "threshold", "getThreshold()I", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(CyclomaticComplexMethod.class, "ignoreSingleWhenExpression", "getIgnoreSingleWhenExpression()Z", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(CyclomaticComplexMethod.class, "ignoreSimpleWhenEntries", "getIgnoreSimpleWhenEntries()Z", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(CyclomaticComplexMethod.class, "ignoreNestingFunctions", "getIgnoreNestingFunctions()Z", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(CyclomaticComplexMethod.class, "nestingFunctions", "getNestingFunctions()Ljava/util/Set;", 0)))};
        $$delegatedProperties = objectArray;
        Companion = new Companion(null);
        objectArray = new String[]{"also", "apply", "forEach", "isNotNull", "ifNull", "let", "run", "use", "with"};
        DEFAULT_NESTING_FUNCTIONS = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lio/gitlab/arturbosch/detekt/rules/complexity/CyclomaticComplexMethod$Companion;", "", "()V", "DEFAULT_NESTING_FUNCTIONS", "", "", "getDEFAULT_NESTING_FUNCTIONS", "()Ljava/util/List;", "detekt-rules-complexity"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<String> getDEFAULT_NESTING_FUNCTIONS() {
            return DEFAULT_NESTING_FUNCTIONS;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

