/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.naming;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.ConfigPropertyKt;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.internal.Configuration;
import io.gitlab.arturbosch.detekt.rules.IdentifierNameKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtProperty;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR!\u0010\t\u001a\u00020\n8BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u000f\u0010\u0010\u0012\u0004\b\u000b\u0010\f\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0016"}, d2={"Lio/gitlab/arturbosch/detekt/rules/naming/VariableMaxLength;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "maximumVariableNameLength", "", "getMaximumVariableNameLength$annotations", "()V", "getMaximumVariableNameLength", "()I", "maximumVariableNameLength$delegate", "Lkotlin/properties/ReadOnlyProperty;", "visitProperty", "", "property", "Lorg/jetbrains/kotlin/psi/KtProperty;", "Companion", "detekt-rules-naming"})
public final class VariableMaxLength
extends Rule {
    @NotNull
    public static final Companion Companion;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final Issue issue;
    @NotNull
    private final ReadOnlyProperty maximumVariableNameLength$delegate;
    private static final int DEFAULT_MAXIMUM_VARIABLE_NAME_LENGTH = 64;

    public VariableMaxLength(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        String string = ((Object)((Object)this)).getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"javaClass.simpleName");
        this.issue = new Issue(string, Severity.Style, "Variable names should not be longer than the maximum set in the configuration.", Debt.Companion.getFIVE_MINS());
        this.maximumVariableNameLength$delegate = ConfigPropertyKt.config((Object)64);
    }

    public /* synthetic */ VariableMaxLength(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    private final int getMaximumVariableNameLength() {
        return ((Number)this.maximumVariableNameLength$delegate.getValue((Object)this, $$delegatedProperties[0])).intValue();
    }

    @Configuration(description="maximum name length")
    private static /* synthetic */ void getMaximumVariableNameLength$annotations() {
    }

    public void visitProperty(@NotNull KtProperty property) {
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        if (IdentifierNameKt.identifierName((KtNamedDeclaration)((KtNamedDeclaration)property)).length() > this.getMaximumVariableNameLength()) {
            this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.atName((KtNamedDeclaration)property), "Variable names should be at most " + this.getMaximumVariableNameLength() + " characters long.", null, null, 24, null));
        }
    }

    public VariableMaxLength() {
        this(null, 1, null);
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(VariableMaxLength.class, "maximumVariableNameLength", "getMaximumVariableNameLength()I", 0)))};
        $$delegatedProperties = kPropertyArray;
        Companion = new Companion(null);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lio/gitlab/arturbosch/detekt/rules/naming/VariableMaxLength$Companion;", "", "()V", "DEFAULT_MAXIMUM_VARIABLE_NAME_LENGTH", "", "detekt-rules-naming"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

