/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.performance;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtExpression;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0002J\u0012\u0010\u0010\u001a\u00020\r2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\u0015H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lio/gitlab/arturbosch/detekt/rules/performance/UnnecessaryTemporaryInstantiation;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "types", "", "", "isPrimitiveWrapperType", "", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "isToStringMethod", "element", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "visitCallExpression", "", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "detekt-rules-performance"})
public final class UnnecessaryTemporaryInstantiation
extends Rule {
    @NotNull
    private final Issue issue;
    private final Set<String> types;

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    public void visitCallExpression(@NotNull KtCallExpression expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        if (this.isPrimitiveWrapperType(expression.getCalleeExpression())) {
            PsiElement psiElement = expression.getNextSibling();
            if (this.isToStringMethod((PsiElement)(psiElement != null ? psiElement.getNextSibling() : null))) {
                this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)expression), (int)0, (int)2, null), this.getIssue().getDescription(), null, null, 24, null));
            }
        }
    }

    private final boolean isPrimitiveWrapperType(KtExpression expression) {
        KtExpression ktExpression = expression;
        return CollectionsKt.contains((Iterable)this.types, (Object)(ktExpression != null ? ktExpression.getText() : null));
    }

    private final boolean isToStringMethod(PsiElement element) {
        PsiElement psiElement = element;
        return Intrinsics.areEqual((Object)(psiElement != null ? psiElement.getText() : null), (Object)"toString()");
    }

    public UnnecessaryTemporaryInstantiation(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        this.issue = new Issue("UnnecessaryTemporaryInstantiation", Severity.Performance, "Avoid temporary objects when converting primitive types to String.", Debt.Companion.getFIVE_MINS());
        this.types = SetsKt.hashSetOf((Object[])new String[]{"Boolean", "Byte", "Short", "Integer", "Long", "Float", "Double"});
    }

    public /* synthetic */ UnnecessaryTemporaryInstantiation(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    public UnnecessaryTemporaryInstantiation() {
        this(null, 1, null);
    }
}

