/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.performance;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.ConfigPropertyKt;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.internal.Configuration;
import io.gitlab.arturbosch.detekt.api.internal.RequiresTypeResolution;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;

@RequiresTypeResolution
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u001a\u0010\u0018\u001a\u00020\u0019*\u00020\u00132\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bH\u0002J\u000e\u0010\u001d\u001a\u0004\u0018\u00010\u0013*\u00020\u0013H\u0002R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR!\u0010\t\u001a\u00020\n8BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u000f\u0010\u0010\u0012\u0004\b\u000b\u0010\f\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lio/gitlab/arturbosch/detekt/rules/performance/CouldBeSequence;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "threshold", "", "getThreshold$annotations", "()V", "getThreshold", "()I", "threshold$delegate", "Lkotlin/properties/ReadOnlyProperty;", "visitedCallExpressions", "", "Lorg/jetbrains/kotlin/psi/KtExpression;", "visitCallExpression", "", "expression", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "isCalling", "", "fqNames", "", "Lorg/jetbrains/kotlin/name/FqName;", "nextChainedCall", "Companion", "detekt-rules-performance"})
public final class CouldBeSequence
extends Rule {
    @NotNull
    public static final Companion Companion;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final Issue issue;
    @NotNull
    private final ReadOnlyProperty threshold$delegate;
    @NotNull
    private List<KtExpression> visitedCallExpressions;
    @NotNull
    private static final List<FqName> operationsFqNames;

    public CouldBeSequence(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        this.issue = new Issue("CouldBeSequence", Severity.Performance, "Several chained collection operations that should be a sequence.", Debt.Companion.getFIVE_MINS());
        this.threshold$delegate = ConfigPropertyKt.config((Object)3);
        this.visitedCallExpressions = new ArrayList();
    }

    public /* synthetic */ CouldBeSequence(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    private final int getThreshold() {
        return ((Number)this.threshold$delegate.getValue((Object)this, $$delegatedProperties[0])).intValue();
    }

    @Configuration(description="the number of chained collection operations required to trigger rule")
    private static /* synthetic */ void getThreshold$annotations() {
    }

    public void visitCallExpression(@NotNull KtCallExpression expression) {
        int counter;
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        super.visitCallExpression(expression);
        if (this.visitedCallExpressions.contains(expression)) {
            return;
        }
        if (!this.isCalling((KtExpression)expression, operationsFqNames)) {
            return;
        }
        KtExpression nextCall = this.nextChainedCall((KtExpression)expression);
        for (counter = 1; counter < this.getThreshold() && nextCall != null; ++counter) {
            ((Collection)this.visitedCallExpressions).add(nextCall);
            if (!this.isCalling(nextCall, operationsFqNames)) break;
            nextCall = this.nextChainedCall(nextCall);
        }
        if (counter >= this.getThreshold()) {
            String message = expression.getText() + " could be .asSequence()." + expression.getText();
            this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)expression), (int)0, (int)2, null), message, null, null, 24, null));
        }
    }

    private final KtExpression nextChainedCall(KtExpression $this$nextChainedCall) {
        KtExpression expression = KtPsiUtilKt.getQualifiedExpressionForSelectorOrThis((KtExpression)$this$nextChainedCall);
        KtQualifiedExpression ktQualifiedExpression = KtPsiUtilKt.getQualifiedExpressionForReceiver((KtExpression)expression);
        return ktQualifiedExpression != null ? ktQualifiedExpression.getSelectorExpression() : null;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isCalling(KtExpression $this$isCalling, List<FqName> fqNames) {
        void $this$filterTo$iv$iv;
        Object object = $this$isCalling instanceof KtCallExpression ? (KtCallExpression)$this$isCalling : null;
        if (object == null || (object = object.getCalleeExpression()) == null || (object = object.getText()) == null) {
            object = $this$isCalling.getText();
        }
        Object calleeText = object;
        Iterable $this$filter$iv = fqNames;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            FqName it = (FqName)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.shortName().asString(), (Object)calleeText)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List targetFqNames = (List)destination$iv$iv;
        if (targetFqNames.isEmpty()) {
            return false;
        }
        ResolvedCall resolvedCall = CallUtilKt.getResolvedCall((KtElement)((KtElement)$this$isCalling), (BindingContext)this.getBindingContext());
        return CollectionsKt.contains((Iterable)targetFqNames, resolvedCall != null && (resolvedCall = resolvedCall.getResultingDescriptor()) != null ? DescriptorUtilsKt.fqNameOrNull((DeclarationDescriptor)((DeclarationDescriptor)resolvedCall)) : null);
    }

    public CouldBeSequence() {
        this(null, 1, null);
    }

    static {
        Object[] objectArray = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(CouldBeSequence.class, "threshold", "getThreshold()I", 0)))};
        $$delegatedProperties = objectArray;
        Companion = new Companion(null);
        objectArray = new FqName[]{new FqName("kotlin.collections.filter"), new FqName("kotlin.collections.filterIndexed"), new FqName("kotlin.collections.map"), new FqName("kotlin.collections.mapIndexed"), new FqName("kotlin.collections.flatMap"), new FqName("kotlin.collections.flatMapIndexed"), new FqName("kotlin.collections.reduce"), new FqName("kotlin.collections.zip")};
        operationsFqNames = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lio/gitlab/arturbosch/detekt/rules/performance/CouldBeSequence$Companion;", "", "()V", "operationsFqNames", "", "Lorg/jetbrains/kotlin/name/FqName;", "detekt-rules-performance"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

