/*
 * Decompiled with CFR 0.152.
 */
package name.velikodniy.vitaliy.fixedlength;

import java.util.Arrays;

public enum Align {
    RIGHT{

        @Override
        public String make(String data, int length, char paddingChar) {
            int dataLength;
            String result = Align.leftPad(data, length, paddingChar);
            if (data == null) {
                data = "";
            }
            if ((dataLength = data.length()) > length) {
                result = Align.substring(data, dataLength - length, dataLength);
            }
            return result;
        }

        @Override
        public String remove(String data, char paddingChar) {
            String result = data;
            if (data == null) {
                result = "";
            }
            while (result.startsWith("" + paddingChar)) {
                result = result.substring(1);
            }
            if (paddingChar == '0' && result.isEmpty()) {
                result = "0";
            }
            return result;
        }
    }
    ,
    LEFT{

        @Override
        public String make(String data, int length, char paddingChar) {
            int dataLength;
            String result = Align.rightPad(data, length, paddingChar);
            if (data == null) {
                data = "";
            }
            if ((dataLength = data.length()) > length) {
                result = Align.substring(data, 0, length);
            }
            return result;
        }

        @Override
        public String remove(String data, char paddingChar) {
            String result = data;
            if (data == null) {
                result = "";
            }
            while (result.endsWith("" + paddingChar)) {
                result = result.substring(0, result.length() - 1);
            }
            return result;
        }
    };

    private static final int MAX_PAD = 8192;

    public abstract String make(String var1, int var2, char var3);

    public abstract String remove(String var1, char var2);

    private static String substring(String str, int start, int end) {
        if (str == null) {
            return null;
        }
        if (end < 0) {
            end = str.length() + end;
        }
        if (start < 0) {
            start = str.length() + start;
        }
        if (end > str.length()) {
            end = str.length();
        }
        if (start > end) {
            return "";
        }
        if (start < 0) {
            start = 0;
        }
        if (end < 0) {
            end = 0;
        }
        return str.substring(start, end);
    }

    private static String leftPad(String str, int size, char padChar) {
        if (str == null) {
            return null;
        }
        int pads = size - str.length();
        if (pads <= 0) {
            return str;
        }
        if (pads > 8192) {
            return Align.leftPad(str, size, Character.toString(padChar));
        }
        return Align.repeat(padChar, pads).concat(str);
    }

    private static String leftPad(String str, int size, String padStr) {
        if (str == null) {
            return null;
        }
        if (padStr == null || padStr.isEmpty()) {
            padStr = " ";
        }
        int padLen = padStr.length();
        int strLen = str.length();
        int pads = size - strLen;
        if (pads <= 0) {
            return str;
        }
        if (padLen == 1 && pads <= 8192) {
            return Align.leftPad(str, size, padStr.charAt(0));
        }
        if (pads == padLen) {
            return padStr.concat(str);
        }
        if (pads < padLen) {
            return padStr.substring(0, pads).concat(str);
        }
        char[] padding = new char[pads];
        char[] padChars = padStr.toCharArray();
        for (int i = 0; i < pads; ++i) {
            padding[i] = padChars[i % padLen];
        }
        return new String(padding).concat(str);
    }

    public static String rightPad(String str, int size, char padChar) {
        if (str == null) {
            return null;
        }
        int pads = size - str.length();
        if (pads <= 0) {
            return str;
        }
        if (pads > 8192) {
            return Align.rightPad(str, size, String.valueOf(padChar));
        }
        return str.concat(Align.repeat(padChar, pads));
    }

    public static String rightPad(String str, int size, String padStr) {
        if (str == null) {
            return null;
        }
        if (padStr == null || padStr.isEmpty()) {
            padStr = " ";
        }
        int padLen = padStr.length();
        int strLen = str.length();
        int pads = size - strLen;
        if (pads <= 0) {
            return str;
        }
        if (padLen == 1 && pads <= 8192) {
            return Align.rightPad(str, size, padStr.charAt(0));
        }
        if (pads == padLen) {
            return str.concat(padStr);
        }
        if (pads < padLen) {
            return str.concat(padStr.substring(0, pads));
        }
        char[] padding = new char[pads];
        char[] padChars = padStr.toCharArray();
        for (int i = 0; i < pads; ++i) {
            padding[i] = padChars[i % padLen];
        }
        return str.concat(new String(padding));
    }

    public static String repeat(char ch, int repeat) {
        if (repeat <= 0) {
            return "";
        }
        char[] buf = new char[repeat];
        Arrays.fill(buf, ch);
        return new String(buf);
    }
}

