/*
 * Decompiled with CFR 0.152.
 */
package name.velikodniy.vitaliy.fixedlength;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Scanner;
import java.util.Spliterators;
import java.util.function.Predicate;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import name.velikodniy.vitaliy.fixedlength.FixedLengthException;
import name.velikodniy.vitaliy.fixedlength.annotation.FixedField;
import name.velikodniy.vitaliy.fixedlength.annotation.FixedLine;
import name.velikodniy.vitaliy.fixedlength.annotation.SplitLineAfter;
import name.velikodniy.vitaliy.fixedlength.formatters.Formatter;

public class FixedLength<T> {
    private static final Logger LOGGER = Logger.getLogger(FixedLength.class.getName());
    private static final Map<Class<? extends Serializable>, Class<? extends Formatter<? extends Serializable>>> FORMATTERS = Formatter.getDefaultFormatters();
    private final Map<Class<? extends Predicate<String>>, Predicate<String>> predicates = new HashMap<Class<? extends Predicate<String>>, Predicate<String>>();
    private final List<FixedFormatLine<? extends T>> lineTypes = new ArrayList<FixedFormatLine<? extends T>>();
    private boolean skipUnknownLines = true;
    private boolean skipErroneousFields = false;
    private boolean skipErroneousLines = false;
    private Charset charset = Charset.defaultCharset();
    private String delimiterString = "\n";
    private Pattern delimiter = Pattern.compile(this.delimiterString);

    private FixedFormatLine<T> classToLineDesc(Class<? extends T> clazz) {
        FixedFormatLine fixedFormatLine = new FixedFormatLine();
        fixedFormatLine.clazz = clazz;
        FixedLine annotation = clazz.getDeclaredAnnotation(FixedLine.class);
        if (annotation != null) {
            fixedFormatLine.setStartsWith(annotation.startsWith());
            fixedFormatLine.predicate = annotation.predicate();
        }
        for (Field field : this.getAllFields(clazz)) {
            FixedField fieldAnnotation = field.getDeclaredAnnotation(FixedField.class);
            if (fieldAnnotation == null) continue;
            fixedFormatLine.fixedFormatFields.add(new FixedFormatField(field, fieldAnnotation));
        }
        for (Method method : clazz.getMethods()) {
            SplitLineAfter splitLineAfter = method.getDeclaredAnnotation(SplitLineAfter.class);
            if (splitLineAfter == null) continue;
            fixedFormatLine.splitAfterMethod = method;
        }
        return fixedFormatLine;
    }

    List<Field> getAllFields(Class<?> clazz) {
        if (clazz == null) {
            return Collections.emptyList();
        }
        ArrayList<Field> result = new ArrayList<Field>(this.getAllFields(clazz.getSuperclass()));
        List filteredFields = Arrays.stream(clazz.getDeclaredFields()).collect(Collectors.toList());
        result.addAll(filteredFields);
        return result;
    }

    public FixedLength<T> registerLineType(Class<? extends T> lineClass) {
        this.lineTypes.add(this.classToLineDesc(lineClass));
        return this;
    }

    public FixedLength<T> registerFormatter(Class<? extends Serializable> typeClass, Class<? extends Formatter<? extends Serializable>> formatterClass) {
        FORMATTERS.put(typeClass, formatterClass);
        return this;
    }

    public FixedLength<T> stopSkipUnknownLines() {
        this.skipUnknownLines = false;
        return this;
    }

    public FixedLength<T> skipErroneousFields() {
        this.skipErroneousFields = true;
        return this;
    }

    public FixedLength<T> skipErroneousLines() {
        this.skipErroneousLines = true;
        return this;
    }

    public FixedLength<T> registerLineTypes(List<Class<T>> lineClasses) {
        this.lineTypes.addAll(lineClasses.stream().map(this::classToLineDesc).collect(Collectors.toList()));
        return this;
    }

    public FixedLength<T> registerLineTypes(Class<T>[] lineClasses) {
        this.registerLineTypes(Arrays.asList(lineClasses));
        return this;
    }

    public FixedLength<T> usingCharset(Charset charset) {
        this.charset = Objects.requireNonNull(charset, "Charset can't be null");
        return this;
    }

    public FixedLength<T> usingLineDelimiter(Pattern pattern) {
        this.delimiter = Objects.requireNonNull(pattern, "Line delimiter pattern can't be null");
        return this;
    }

    public FixedLength<T> usingLineDelimiter(String delimiterString) {
        this.delimiterString = Objects.requireNonNull(delimiterString, "Delimiter can't be null");
        this.delimiter = Pattern.compile("delimiterString");
        return this;
    }

    private Predicate<String> getPredicate(Class<? extends Predicate<String>> clazz) {
        Predicate<String> predicate;
        if (this.predicates.containsKey(clazz)) {
            return this.predicates.get(clazz);
        }
        try {
            predicate = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new FixedLengthException("Cannot init predicate, it should have empty constructor", e);
        }
        this.predicates.put(clazz, predicate);
        return predicate;
    }

    private FixedFormatRecord fixedFormatLine(String line) {
        for (FixedFormatLine<T> lineType : this.lineTypes) {
            if (!lineType.getStartsWith().map(line::startsWith).orElse(true).booleanValue() || !lineType.getPredicate().map(this::getPredicate).map(p -> p.test(line)).orElse(true).booleanValue()) continue;
            return new FixedFormatRecord(line, lineType);
        }
        if (!this.skipUnknownLines) {
            throw new FixedLengthException("Find unknown line:\n " + line);
        }
        return null;
    }

    private T lineToObject(FixedFormatRecord fixedFormatRecord) {
        Class clazz = fixedFormatRecord.fixedFormatLine.clazz;
        String line = fixedFormatRecord.rawLine;
        T lineAsObject = null;
        boolean useEmptyConstructor = true;
        try {
            lineAsObject = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (NoSuchMethodException e) {
            LOGGER.fine("No empty constructor in class");
            useEmptyConstructor = false;
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new FixedLengthException("Unable to instantiate " + clazz.getName(), e);
        }
        Object[] args = new Object[fixedFormatRecord.fixedFormatLine.fixedFormatFields.size()];
        int index = 0;
        for (FixedFormatField fixedFormatField : fixedFormatRecord.fixedFormatLine.fixedFormatFields) {
            String str;
            FixedField fieldAnnotation = fixedFormatField.getFixedFieldAnnotation();
            Field field = fixedFormatField.getField();
            int startOfFieldIndex = fieldAnnotation.offset() - 1;
            int endOfFieldIndex = startOfFieldIndex + fieldAnnotation.length();
            if (endOfFieldIndex > line.length() || !this.acceptFieldContent(str = fieldAnnotation.align().remove(line.substring(startOfFieldIndex, endOfFieldIndex), fieldAnnotation.padding()), fieldAnnotation)) continue;
            if (useEmptyConstructor) {
                this.fillField(field, lineAsObject, str, fieldAnnotation);
                continue;
            }
            args[index++] = Formatter.instance(FORMATTERS, field.getType()).asObject(str, fieldAnnotation);
        }
        if (!useEmptyConstructor) {
            try {
                if (clazz.getDeclaredConstructors().length != 1) {
                    throw new FixedLengthException("There should be only one matching constructor");
                }
                lineAsObject = (T)clazz.getDeclaredConstructors()[0].newInstance(args);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                throw new FixedLengthException("Unable to instantiate " + clazz.getName(), e);
            }
        }
        return lineAsObject;
    }

    private void fillField(Field field, T lineAsObject, String str, FixedField fieldAnnotation) {
        field.setAccessible(true);
        try {
            field.set(lineAsObject, Formatter.instance(FORMATTERS, field.getType()).asObject(str, fieldAnnotation));
        }
        catch (IllegalAccessException e) {
            throw new FixedLengthException("Access to field failed", e);
        }
        catch (Exception e) {
            if (e instanceof FixedLengthException) {
                throw e;
            }
            if (!this.skipErroneousFields) {
                throw e;
            }
            LOGGER.warning(String.format("Skipping field of type %s with error in value %s", field.getType(), str));
        }
    }

    private boolean acceptFieldContent(String content, FixedField fieldAnnotation) {
        if (content == null) {
            return false;
        }
        if (content.trim().isEmpty() && !fieldAnnotation.allowEmptyStrings()) {
            return false;
        }
        if (fieldAnnotation.ignore().isEmpty()) {
            return true;
        }
        Pattern pattern = Pattern.compile(fieldAnnotation.ignore());
        return !pattern.matcher(content).matches();
    }

    private List<T> lineToObjects(FixedFormatRecord fixedFormatRecord) {
        try {
            int splitIndex;
            T lineAsObject = this.lineToObject(fixedFormatRecord);
            Method splitMethod = fixedFormatRecord.fixedFormatLine.splitAfterMethod;
            if (splitMethod == null) {
                return Collections.singletonList(lineAsObject);
            }
            try {
                splitIndex = (Integer)splitMethod.invoke(lineAsObject, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new FixedLengthException("Access to method failed", e);
            }
            if (splitIndex <= 0 || splitIndex >= fixedFormatRecord.rawLine.length()) {
                return Collections.singletonList(lineAsObject);
            }
            String subRawLine = fixedFormatRecord.rawLine.substring(splitIndex);
            FixedFormatRecord subRecord = this.fixedFormatLine(subRawLine);
            if (subRecord == null) {
                return Collections.singletonList(lineAsObject);
            }
            ArrayList<T> lineAsObjects = new ArrayList<T>();
            lineAsObjects.add(lineAsObject);
            lineAsObjects.addAll(this.lineToObjects(subRecord));
            return lineAsObjects;
        }
        catch (Exception e) {
            if (e instanceof FixedLengthException) {
                throw e;
            }
            if (!this.skipErroneousLines) {
                throw e;
            }
            LOGGER.warning("Skipping line with error");
            return Collections.emptyList();
        }
    }

    public List<T> parse(InputStream stream) throws FixedLengthException {
        return this.parseAsStream(stream).collect(Collectors.toList());
    }

    public List<T> parse(Reader reader) throws FixedLengthException {
        return this.parseAsStream(reader).collect(Collectors.toList());
    }

    public Stream<T> parseAsStream(InputStream inputStream) throws FixedLengthException {
        Stream<String> lines = StreamSupport.stream(Spliterators.spliterator(new Scanner(inputStream, this.charset.name()).useDelimiter(this.delimiter), Long.MAX_VALUE, 272), false);
        return this.parseAsStream(lines);
    }

    public Stream<T> parseAsStream(Reader reader) throws FixedLengthException {
        return this.parseAsStream(new BufferedReader(reader).lines());
    }

    private Stream<T> parseAsStream(Stream<String> lines) throws FixedLengthException {
        if (this.lineTypes.isEmpty()) {
            throw new FixedLengthException("Specify at least one line type");
        }
        return lines.map(this::fixedFormatLine).filter(Objects::nonNull).flatMap(fixedFormatRecord -> this.lineToObjects((FixedFormatRecord)fixedFormatRecord).stream());
    }

    public String format(List<T> lines) {
        StringBuilder builder = new StringBuilder();
        long currentLine = 1L;
        for (Object line : lines) {
            this.getAllFields(line.getClass()).stream().filter(f -> f.getAnnotation(FixedField.class) != null).sorted(Comparator.comparingInt(f -> f.getAnnotation(FixedField.class).offset())).forEach(f -> {
                Object value;
                FixedField fixedFieldAnnotation = f.getAnnotation(FixedField.class);
                Formatter<?> formatter = Formatter.instance(FORMATTERS, f.getType());
                f.setAccessible(true);
                try {
                    value = f.get(line);
                }
                catch (IllegalAccessException e) {
                    throw new FixedLengthException(e.getMessage(), e);
                }
                if (value != null) {
                    builder.append(fixedFieldAnnotation.align().make(formatter.asString(value, fixedFieldAnnotation), fixedFieldAnnotation.length(), fixedFieldAnnotation.padding()));
                }
            });
            if ((long)lines.size() == currentLine++) continue;
            builder.append(this.delimiterString);
        }
        return builder.toString();
    }

    private static final class FixedFormatField {
        private final Field field;
        private final FixedField fixedFieldAnnotation;

        private FixedFormatField(Field field, FixedField fixedField) {
            this.field = field;
            this.fixedFieldAnnotation = fixedField;
        }

        public Field getField() {
            return this.field;
        }

        public FixedField getFixedFieldAnnotation() {
            return this.fixedFieldAnnotation;
        }
    }

    private static class FixedFormatLine<T> {
        private String startsWith = null;
        private Class<? extends Predicate<String>> predicate;
        private Class<? extends T> clazz;
        private final List<FixedFormatField> fixedFormatFields = new ArrayList<FixedFormatField>();
        private Method splitAfterMethod;

        private FixedFormatLine() {
        }

        public Optional<String> getStartsWith() {
            return Optional.ofNullable(this.startsWith).flatMap(s -> s.isEmpty() ? Optional.empty() : Optional.of(s));
        }

        public Optional<Class<? extends Predicate<String>>> getPredicate() {
            return Optional.ofNullable(this.predicate);
        }

        public void setStartsWith(String startsWith) {
            this.startsWith = startsWith;
        }

        public void setPredicate(Class<? extends Predicate<String>> predicate) {
            this.predicate = predicate;
        }

        public Class<? extends T> getClazz() {
            return this.clazz;
        }

        public void setClazz(Class<T> clazz) {
            this.clazz = clazz;
        }
    }

    private final class FixedFormatRecord {
        private final String rawLine;
        private final FixedFormatLine<? extends T> fixedFormatLine;

        private FixedFormatRecord(String rawLine, FixedFormatLine<? extends T> fixedFormatLine) {
            this.rawLine = rawLine;
            this.fixedFormatLine = fixedFormatLine;
        }
    }
}

