/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import net.bull.javamelody.internal.model.Counter;

public class LoggingHandler
extends Handler {
    private static final Level THRESHOLD = Level.WARNING;
    private static final Counter LOG_COUNTER = new Counter("log", "log.png");
    private static final LoggingHandler SINGLETON;

    static LoggingHandler getSingleton() {
        return SINGLETON;
    }

    static Counter getLogCounter() {
        return LOG_COUNTER;
    }

    static void addErrorLogToCounter(String message, Throwable throwable) {
        if (throwable == null) {
            LoggingHandler.addErrorLogToCounter(message, (String)null);
        } else {
            StringWriter stackTrace = new StringWriter(200);
            throwable.printStackTrace(new PrintWriter(stackTrace));
            LoggingHandler.addErrorLogToCounter(message, stackTrace.toString());
        }
    }

    static void addErrorLogToCounter(String message, String throwableStackTrace) {
        LOG_COUNTER.addRequestForSystemError(message, -1L, -1L, throwableStackTrace);
    }

    void register() {
        for (String name : this.getLoggerNames()) {
            Logger.getLogger(name).addHandler(this);
        }
    }

    void deregister() {
        for (String name : this.getLoggerNames()) {
            Logger.getLogger(name).removeHandler(this);
        }
    }

    private List<String> getLoggerNames() {
        while (true) {
            try {
                return Collections.list(LogManager.getLogManager().getLoggerNames());
            }
            catch (ConcurrentModificationException e) {
                continue;
            }
            break;
        }
    }

    @Override
    public void publish(LogRecord record) {
        if (record.getLevel().intValue() < THRESHOLD.intValue()) {
            return;
        }
        LoggingHandler.addErrorLogToCounter(record.getLevel().getName() + ": " + record.getMessage(), record.getThrown());
    }

    @Override
    public void close() {
    }

    @Override
    public void flush() {
    }

    static {
        LOG_COUNTER.setMaxRequestsCount(500);
        SINGLETON = new LoggingHandler();
    }
}

