/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.parser;

import java.util.ArrayList;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.LocalBinding;
import net.sf.saxon.expr.parser.Tokenizer;
import net.sf.saxon.expr.parser.XPathParser;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.query.AnnotationList;
import net.sf.saxon.query.XQueryFunction;
import net.sf.saxon.query.XQueryParser;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.z.IntSet;

public class ParserExtension {
    private void needHof(XPathParser p, String what) throws XPathException {
        p.grumble(what + " require support for higher-order-functions, which needs Saxon-PE or higher");
    }

    private void needExtension(XPathParser p, String what) throws XPathException {
        p.grumble(what + " require support for Saxon extensions, available in Saxon-PE or higher");
    }

    private void needUpdate(XPathParser p, String what) throws XPathException {
        p.grumble(what + " requires support for XQuery Update, available in Saxon-EE or higher");
    }

    public Expression parseNamedFunctionReference(XPathParser p) throws XPathException {
        this.needHof(p, "Named function references");
        return null;
    }

    public ItemType parseFunctionItemType(XPathParser p, AnnotationList annotations) throws XPathException {
        this.needHof(p, "Function item types");
        return null;
    }

    public ItemType parseExtendedItemType(XPathParser p) throws XPathException {
        Tokenizer t = p.getTokenizer();
        if (t.currentToken == 48) {
            this.needExtension(p, "Type aliases");
        } else if (t.currentToken == 69 && t.currentTokenValue.equals("tuple")) {
            this.needExtension(p, "Tuple types");
        } else if (t.currentToken == 69 && t.currentTokenValue.equals("union")) {
            this.needExtension(p, "Inline union types");
        }
        return null;
    }

    public Expression parseTildePattern(XPathParser p) throws XPathException {
        this.needExtension(p, "Type aliases");
        return null;
    }

    public Expression makeArgumentPlaceMarker(XPathParser p) throws XPathException {
        this.needHof(p, "Argument place-holders");
        return null;
    }

    protected Expression parseInlineFunction(XPathParser p, AnnotationList annotations) throws XPathException {
        this.needHof(p, "Inline functions");
        return null;
    }

    public Expression parseSimpleInlineFunction(XPathParser p) throws XPathException {
        this.needExtension(p, "Simple inline functions");
        return null;
    }

    public Expression makeCurriedFunction(XPathParser parser, int offset, StructuredQName name, Expression[] args, IntSet placeMarkers) throws XPathException {
        this.needHof(parser, "Partially applied functions");
        return null;
    }

    public LocalBinding findOuterRangeVariable(XPathParser p, StructuredQName qName) {
        return null;
    }

    public Expression createDynamicCurriedFunction(XPathParser p, Expression functionItem, ArrayList<Expression> args, IntSet placeMarkers) throws XPathException {
        this.needHof(p, "Partial function application");
        return null;
    }

    public void handleExternalFunctionDeclaration(XQueryParser p, XQueryFunction func) throws XPathException {
        this.needExtension(p, "External function declarations");
    }

    public void parseTypeAliasDeclaration(XQueryParser p) throws XPathException {
        this.needExtension(p, "Type alias declarations");
    }

    public void parseRevalidationDeclaration(XQueryParser p) throws XPathException {
        this.needUpdate(p, "A revalidation declaration");
    }

    public void parseUpdatingFunctionDeclaration(XQueryParser p) throws XPathException {
        this.needUpdate(p, "An updating function");
    }

    protected Expression parseExtendedExprSingle(XPathParser p) throws XPathException {
        return null;
    }
}

