/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.resource;

import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.lib.CollectionFinder;
import net.sf.saxon.lib.CollectionURIResolver;
import net.sf.saxon.lib.ParseOptions;
import net.sf.saxon.lib.ResourceCollection;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SpaceStrippingRule;
import net.sf.saxon.om.TreeInfo;
import net.sf.saxon.resource.XmlResource;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.AnyURIValue;

public class CollectionURIResolverWrapper
implements CollectionFinder {
    private CollectionURIResolver collectionURIResolver = null;

    public CollectionURIResolverWrapper(CollectionURIResolver cr) {
        this.collectionURIResolver = cr;
    }

    @Override
    public ResourceCollection findCollection(XPathContext context, final String collectionURI) throws XPathException {
        return new ResourceCollection(){
            private SpaceStrippingRule whitespaceRules;

            @Override
            public String getCollectionURI() {
                return collectionURI;
            }

            @Override
            public Iterator<String> getResourceURIs(XPathContext context) throws XPathException {
                ArrayList uris = new ArrayList();
                SequenceIterator<?> iter = CollectionURIResolverWrapper.this.collectionURIResolver.resolve(collectionURI, "", context);
                iter.forEachOrFail(item -> {
                    if (item instanceof AnyURIValue) {
                        uris.add(item.getStringValue());
                    } else if (item instanceof NodeInfo) {
                        uris.add(((NodeInfo)item).getSystemId());
                    } else {
                        throw new XPathException("Result of CollectionURIResolver must consist of xs:anyURI values and/or nodes");
                    }
                });
                return uris.iterator();
            }

            public Iterator<XmlResource> getResources(XPathContext context) throws XPathException {
                ArrayList resources = new ArrayList();
                SequenceIterator<?> iter = CollectionURIResolverWrapper.this.collectionURIResolver.resolve(collectionURI, "", context);
                Configuration config = context.getConfiguration();
                URIResolver uriResolver = config.getURIResolver();
                ParseOptions options = new ParseOptions(config.getParseOptions());
                options.setSpaceStrippingRule(this.whitespaceRules);
                iter.forEachOrFail(item -> {
                    if (item instanceof AnyURIValue) {
                        Source source;
                        try {
                            source = uriResolver.resolve(item.getStringValue(), "");
                        }
                        catch (TransformerException e) {
                            throw XPathException.makeXPathException(e);
                        }
                        TreeInfo treeInfo = config.buildDocumentTree(source, options);
                        resources.add(new XmlResource(treeInfo.getRootNode()));
                    } else if (item instanceof NodeInfo) {
                        resources.add(new XmlResource((NodeInfo)item));
                    } else {
                        throw new XPathException("Result of CollectionURIResolver must consist of xs:anyURI values and/or nodes");
                    }
                });
                return resources.iterator();
            }

            @Override
            public boolean isStable(XPathContext context) {
                return false;
            }

            @Override
            public boolean stripWhitespace(SpaceStrippingRule rules) {
                this.whitespaceRules = rules;
                return true;
            }
        };
    }

    public CollectionURIResolver getCollectionURIResolver() {
        return this.collectionURIResolver;
    }
}

