/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.bestpractices;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceBody;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceBodyDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTEnumBody;
import net.sourceforge.pmd.lang.java.ast.ASTEnumConstant;
import net.sourceforge.pmd.lang.java.ast.ASTEnumDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTName;
import net.sourceforge.pmd.lang.java.ast.ASTPrimaryPrefix;
import net.sourceforge.pmd.lang.java.ast.ASTPrimarySuffix;
import net.sourceforge.pmd.lang.java.ast.AbstractJavaNode;
import net.sourceforge.pmd.lang.java.ast.AccessNode;
import net.sourceforge.pmd.lang.java.ast.Annotatable;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.rule.AbstractLombokAwareRule;
import net.sourceforge.pmd.lang.java.symboltable.JavaNameOccurrence;
import net.sourceforge.pmd.lang.java.symboltable.VariableNameDeclaration;
import net.sourceforge.pmd.lang.symboltable.NameDeclaration;
import net.sourceforge.pmd.lang.symboltable.NameOccurrence;

public class UnusedPrivateFieldRule
extends AbstractLombokAwareRule {
    @Override
    protected Collection<String> defaultSuppressionAnnotations() {
        ArrayList<String> defaultValues = new ArrayList<String>(super.defaultSuppressionAnnotations());
        defaultValues.add("java.lang.Deprecated");
        defaultValues.add("javafx.fxml.FXML");
        defaultValues.add("lombok.experimental.Delegate");
        defaultValues.add("lombok.EqualsAndHashCode");
        return defaultValues;
    }

    @Override
    public Object visit(ASTClassOrInterfaceDeclaration node, Object data) {
        if (this.hasIgnoredAnnotation(node)) {
            return super.visit(node, data);
        }
        Map vars = node.getScope().getDeclarations(VariableNameDeclaration.class);
        for (Map.Entry entry : vars.entrySet()) {
            VariableNameDeclaration decl = (VariableNameDeclaration)entry.getKey();
            AccessNode accessNodeParent = decl.getAccessNodeParent();
            if (!accessNodeParent.isPrivate() || this.isOK(decl.getImage()) || this.hasIgnoredAnnotation((Annotatable)((Object)accessNodeParent)) || this.actuallyUsed((List)entry.getValue()) || this.usedInOuterClass(node, (NameDeclaration)decl) || this.usedInOuterEnum(node, (NameDeclaration)decl)) continue;
            this.addViolation(data, (Node)decl.getNode(), decl.getImage());
        }
        return super.visit(node, data);
    }

    private boolean usedInOuterEnum(ASTClassOrInterfaceDeclaration node, NameDeclaration decl) {
        List outerEnums = node.getParentsOfType(ASTEnumDeclaration.class);
        for (ASTEnumDeclaration outerEnum : outerEnums) {
            ASTEnumBody enumBody = (ASTEnumBody)outerEnum.getFirstChildOfType(ASTEnumBody.class);
            if (!this.usedInOuter(decl, enumBody)) continue;
            return true;
        }
        return false;
    }

    private boolean usedInOuterClass(ASTClassOrInterfaceDeclaration node, NameDeclaration decl) {
        List outerClasses = node.getParentsOfType(ASTClassOrInterfaceDeclaration.class);
        for (ASTClassOrInterfaceDeclaration outerClass : outerClasses) {
            ASTClassOrInterfaceBody classOrInterfaceBody = (ASTClassOrInterfaceBody)outerClass.getFirstChildOfType(ASTClassOrInterfaceBody.class);
            if (!this.usedInOuter(decl, classOrInterfaceBody)) continue;
            return true;
        }
        return false;
    }

    private boolean usedInOuter(NameDeclaration decl, JavaNode body) {
        List classOrInterfaceBodyDeclarations = body.findChildrenOfType(ASTClassOrInterfaceBodyDeclaration.class);
        List enumConstants = body.findChildrenOfType(ASTEnumConstant.class);
        ArrayList nodes = new ArrayList();
        nodes.addAll(classOrInterfaceBodyDeclarations);
        nodes.addAll(enumConstants);
        for (AbstractJavaNode node : nodes) {
            for (ASTPrimarySuffix primarySuffix : node.findDescendantsOfType(ASTPrimarySuffix.class, true)) {
                if (!decl.getImage().equals(primarySuffix.getImage())) continue;
                return true;
            }
            for (ASTPrimaryPrefix primaryPrefix : node.findDescendantsOfType(ASTPrimaryPrefix.class, true)) {
                ASTName name = (ASTName)primaryPrefix.getFirstDescendantOfType(ASTName.class);
                if (name == null) continue;
                for (String id : name.getImage().split("\\.")) {
                    if (!id.equals(decl.getImage())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean actuallyUsed(List<NameOccurrence> usages) {
        for (NameOccurrence nameOccurrence : usages) {
            JavaNameOccurrence jNameOccurrence = (JavaNameOccurrence)nameOccurrence;
            if (jNameOccurrence.isOnLeftHandSide()) continue;
            return true;
        }
        return false;
    }

    private boolean isOK(String image) {
        return "serialVersionUID".equals(image) || "serialPersistentFields".equals(image) || "IDENT".equals(image);
    }
}

