/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.network;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.management.ObjectName;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.jmx.AnnotatedMBean;
import org.apache.activemq.broker.jmx.BrokerMBeanSupport;
import org.apache.activemq.broker.jmx.NetworkBridgeView;
import org.apache.activemq.broker.jmx.NetworkDestinationView;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.Message;
import org.apache.activemq.network.NetworkBridge;
import org.apache.activemq.network.NetworkBridgeConfiguration;
import org.apache.activemq.thread.Scheduler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MBeanBridgeDestination {
    private static final Logger LOG = LoggerFactory.getLogger(MBeanBridgeDestination.class);
    private final BrokerService brokerService;
    private final NetworkBridge bridge;
    private final NetworkBridgeView networkBridgeView;
    private final NetworkBridgeConfiguration networkBridgeConfiguration;
    private final Scheduler scheduler;
    private final Runnable purgeInactiveDestinationViewTask;
    private Map<ActiveMQDestination, ObjectName> destinationObjectNameMap = new ConcurrentHashMap<ActiveMQDestination, ObjectName>();
    private Map<ActiveMQDestination, NetworkDestinationView> outboundDestinationViewMap = new ConcurrentHashMap<ActiveMQDestination, NetworkDestinationView>();
    private Map<ActiveMQDestination, NetworkDestinationView> inboundDestinationViewMap = new ConcurrentHashMap<ActiveMQDestination, NetworkDestinationView>();

    public MBeanBridgeDestination(BrokerService brokerService, NetworkBridgeConfiguration networkBridgeConfiguration, NetworkBridge bridge, NetworkBridgeView networkBridgeView) {
        this.brokerService = brokerService;
        this.networkBridgeConfiguration = networkBridgeConfiguration;
        this.bridge = bridge;
        this.networkBridgeView = networkBridgeView;
        this.scheduler = brokerService.getScheduler();
        this.purgeInactiveDestinationViewTask = new Runnable(){

            @Override
            public void run() {
                MBeanBridgeDestination.this.purgeInactiveDestinationViews();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onOutboundMessage(Message message) {
        ActiveMQDestination destination = message.getDestination();
        NetworkDestinationView networkDestinationView = this.outboundDestinationViewMap.get(destination);
        if (networkDestinationView == null) {
            Map<ActiveMQDestination, ObjectName> map = this.destinationObjectNameMap;
            synchronized (map) {
                networkDestinationView = this.outboundDestinationViewMap.get(destination);
                if (networkDestinationView == null) {
                    ObjectName bridgeObjectName = this.bridge.getMbeanObjectName();
                    try {
                        ObjectName objectName = BrokerMBeanSupport.createNetworkOutBoundDestinationObjectName(bridgeObjectName, destination);
                        networkDestinationView = new NetworkDestinationView(this.networkBridgeView, destination.getPhysicalName());
                        AnnotatedMBean.registerMBean(this.brokerService.getManagementContext(), networkDestinationView, objectName);
                        this.destinationObjectNameMap.put(destination, objectName);
                        this.outboundDestinationViewMap.put(destination, networkDestinationView);
                    }
                    catch (Exception e) {
                        LOG.warn("Failed to register " + destination, e);
                    }
                }
            }
        }
        networkDestinationView.messageSent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onInboundMessage(Message message) {
        ActiveMQDestination destination = message.getDestination();
        NetworkDestinationView networkDestinationView = this.inboundDestinationViewMap.get(destination);
        if (networkDestinationView == null) {
            Map<ActiveMQDestination, ObjectName> map = this.destinationObjectNameMap;
            synchronized (map) {
                networkDestinationView = this.inboundDestinationViewMap.get(destination);
                if (networkDestinationView == null) {
                    ObjectName bridgeObjectName = this.bridge.getMbeanObjectName();
                    try {
                        ObjectName objectName = BrokerMBeanSupport.createNetworkInBoundDestinationObjectName(bridgeObjectName, destination);
                        networkDestinationView = new NetworkDestinationView(this.networkBridgeView, destination.getPhysicalName());
                        this.networkBridgeView.addNetworkDestinationView(networkDestinationView);
                        AnnotatedMBean.registerMBean(this.brokerService.getManagementContext(), networkDestinationView, objectName);
                        this.destinationObjectNameMap.put(destination, objectName);
                        this.inboundDestinationViewMap.put(destination, networkDestinationView);
                    }
                    catch (Exception e) {
                        LOG.warn("Failed to register " + destination, e);
                    }
                }
            }
        }
        networkDestinationView.messageSent();
    }

    public void start() {
        long period;
        if (this.networkBridgeConfiguration.isGcDestinationViews() && (period = this.networkBridgeConfiguration.getGcSweepTime()) > 0L) {
            this.scheduler.executePeriodically(this.purgeInactiveDestinationViewTask, period);
        }
    }

    public void stop() {
        if (!this.brokerService.isUseJmx()) {
            return;
        }
        this.scheduler.cancel(this.purgeInactiveDestinationViewTask);
        for (ObjectName objectName : this.destinationObjectNameMap.values()) {
            try {
                if (objectName == null) continue;
                this.brokerService.getManagementContext().unregisterMBean(objectName);
            }
            catch (Throwable e) {
                LOG.debug("Network bridge could not be unregistered in JMX: {}", (Object)e.getMessage(), (Object)e);
            }
        }
        this.destinationObjectNameMap.clear();
        this.outboundDestinationViewMap.clear();
        this.inboundDestinationViewMap.clear();
    }

    private void purgeInactiveDestinationViews() {
        if (!this.brokerService.isUseJmx()) {
            return;
        }
        this.purgeInactiveDestinationView(this.inboundDestinationViewMap);
        this.purgeInactiveDestinationView(this.outboundDestinationViewMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void purgeInactiveDestinationView(Map<ActiveMQDestination, NetworkDestinationView> map) {
        long time = System.currentTimeMillis() - this.networkBridgeConfiguration.getGcSweepTime();
        for (Map.Entry<ActiveMQDestination, NetworkDestinationView> entry : map.entrySet()) {
            if (entry.getValue().getLastAccessTime() > time) continue;
            Map<ActiveMQDestination, ObjectName> map2 = this.destinationObjectNameMap;
            synchronized (map2) {
                map.remove(entry.getKey());
                ObjectName objectName = this.destinationObjectNameMap.remove(entry.getKey());
                if (objectName != null) {
                    try {
                        if (objectName != null) {
                            this.brokerService.getManagementContext().unregisterMBean(objectName);
                        }
                    }
                    catch (Throwable e) {
                        LOG.debug("Network bridge could not be unregistered in JMX: {}", (Object)e.getMessage(), (Object)e);
                    }
                }
                entry.getValue().close();
            }
        }
    }
}

