/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.yaml.io;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.camel.util.json.JsonArray;
import org.apache.camel.util.json.JsonObject;

class EipNode {
    private final String name;
    private final EipNode parent;
    private final boolean output;
    private final boolean expression;
    private EipNode input;
    private List<EipNode> outputs;
    private List<EipNode> expressions;
    private String text;
    private Map<String, Object> properties;

    public EipNode(String name, EipNode parent, boolean output, boolean expression) {
        this.name = name;
        this.parent = parent;
        this.output = output;
        this.expression = expression;
    }

    public String getName() {
        return this.name;
    }

    public EipNode getParent() {
        return this.parent;
    }

    public EipNode getInput() {
        return this.input;
    }

    public void setInput(EipNode input) {
        this.input = input;
    }

    public boolean isOutput() {
        return this.output;
    }

    public boolean isExpression() {
        return this.expression;
    }

    public List<EipNode> getOutputs() {
        if (this.outputs == null) {
            return Collections.emptyList();
        }
        return this.outputs;
    }

    public void addOutput(EipNode output) {
        if (this.outputs == null) {
            this.outputs = new ArrayList<EipNode>();
        }
        this.outputs.add(output);
    }

    public List<EipNode> getExpressions() {
        if (this.expressions == null) {
            return Collections.emptyList();
        }
        return this.expressions;
    }

    public void addExpression(EipNode output) {
        if (this.expressions == null) {
            this.expressions = new ArrayList<EipNode>();
        }
        this.expressions.add(output);
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public Map<String, Object> getProperties() {
        if (this.properties == null) {
            return Collections.emptyMap();
        }
        return this.properties;
    }

    public void addProperty(String key, Object value) {
        if (this.properties == null) {
            this.properties = new LinkedHashMap<String, Object>();
        }
        this.properties.put(key, value);
    }

    public String toString() {
        return this.name;
    }

    JsonObject asJsonObject() {
        JsonObject answer = new JsonObject();
        if (this.properties != null) {
            answer.putAll(this.properties);
        }
        if (this.expressions != null) {
            for (EipNode o : this.expressions) {
                JsonObject wrap;
                String key = o.getName();
                String language = (String)o.getProperties().remove("language");
                JsonObject r = o.asJsonObject();
                if (!key.equals(o.getName())) {
                    wrap = new JsonObject();
                    wrap.put((Object)o.getName(), (Object)r);
                    answer.put((Object)key, (Object)wrap);
                    continue;
                }
                if (language != null && !key.equals(language)) {
                    wrap = new JsonObject();
                    wrap.put((Object)language, (Object)r);
                    answer.put((Object)key, (Object)wrap);
                    continue;
                }
                answer.put((Object)key, (Object)r);
            }
        }
        if (this.outputs != null) {
            this.outputs.sort((o1, o2) -> {
                if ("otherwise".equals(o1.name)) {
                    return 1;
                }
                if ("otherwise".equals(o2.name)) {
                    return -1;
                }
                return 0;
            });
            if (("marshal".equals(this.name) || "unmarshal".equals(this.name)) && this.outputs.size() == 1) {
                EipNode o = this.outputs.get(0);
                JsonObject jo = o.asJsonObject();
                answer.put((Object)o.getName(), (Object)jo);
            } else {
                JsonArray arr = new JsonArray();
                for (EipNode o : this.outputs) {
                    JsonObject r = o.asJsonObject();
                    JsonObject wrap = new JsonObject();
                    wrap.put((Object)o.getName(), (Object)r);
                    arr.add((Object)wrap);
                }
                answer.put((Object)"steps", (Object)arr);
            }
        }
        return answer;
    }
}

