/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.policy.builders;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.ws.policy.AssertionBuilder;
import org.apache.cxf.ws.policy.PolicyAssertion;
import org.apache.cxf.ws.policy.PolicyBuilder;
import org.apache.cxf.ws.policy.builder.xml.XmlPrimitiveAssertion;
import org.apache.cxf.ws.security.policy.SP11Constants;
import org.apache.cxf.ws.security.policy.SP12Constants;
import org.apache.cxf.ws.security.policy.SPConstants;
import org.apache.cxf.ws.security.policy.model.HttpsToken;
import org.apache.cxf.ws.security.policy.model.TransportToken;
import org.apache.neethi.Policy;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransportTokenBuilder
implements AssertionBuilder {
    private static final List<QName> KNOWN_ELEMENTS = Arrays.asList(SP11Constants.TRANSPORT_TOKEN, SP12Constants.TRANSPORT_TOKEN);
    PolicyBuilder builder;

    public TransportTokenBuilder(PolicyBuilder b) {
        this.builder = b;
    }

    public PolicyAssertion build(Element element) throws IllegalArgumentException {
        SPConstants consts = "http://schemas.xmlsoap.org/ws/2005/07/securitypolicy".equals(element.getNamespaceURI()) ? SP11Constants.INSTANCE : SP12Constants.INSTANCE;
        TransportToken transportToken = new TransportToken(consts);
        Policy policy = this.builder.getPolicy(DOMUtils.getFirstElement((Node)element));
        Iterator iterator = (policy = (Policy)policy.normalize(false)).getAlternatives();
        if (iterator.hasNext()) {
            this.processAlternative((List)iterator.next(), transportToken);
        }
        return transportToken;
    }

    public List<QName> getKnownElements() {
        return KNOWN_ELEMENTS;
    }

    private void processAlternative(List assertions, TransportToken parent) {
        for (XmlPrimitiveAssertion primtive : assertions) {
            Element child;
            HttpsToken httpsToken;
            QName qname = primtive.getName();
            if (SP11Constants.HTTPS_TOKEN.equals(qname)) {
                httpsToken = new HttpsToken(SP11Constants.INSTANCE);
                String attr = DOMUtils.getAttribute((Element)primtive.getValue(), (QName)SPConstants.REQUIRE_CLIENT_CERTIFICATE);
                if (attr != null) {
                    httpsToken.setRequireClientCertificate("true".equals(attr));
                }
                parent.setToken(httpsToken);
                continue;
            }
            if (!SP12Constants.HTTPS_TOKEN.equals(qname)) continue;
            httpsToken = new HttpsToken(SP12Constants.INSTANCE);
            Element element = DOMUtils.getFirstChildWithName((Element)primtive.getValue(), (QName)SPConstants.POLICY);
            if (element == null || (child = DOMUtils.getFirstElement((Node)element)) == null) continue;
            if (SP12Constants.HTTP_BASIC_AUTHENTICATION.equals(DOMUtils.getElementQName((Element)child))) {
                httpsToken.setHttpBasicAuthentication(true);
                continue;
            }
            if (SP12Constants.HTTP_DIGEST_AUTHENTICATION.equals(DOMUtils.getElementQName((Element)child))) {
                httpsToken.setHttpDigestAuthentication(true);
                continue;
            }
            if (!SP12Constants.REQUIRE_CLIENT_CERTIFICATE.equals(DOMUtils.getElementQName((Element)child))) continue;
            httpsToken.setRequireClientCertificate(true);
        }
    }

    public PolicyAssertion buildCompatible(PolicyAssertion a, PolicyAssertion b) {
        return null;
    }
}

