/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.policy.builders;

import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.ws.policy.PolicyConstants;
import org.apache.cxf.ws.security.policy.SP11Constants;
import org.apache.cxf.ws.security.policy.SP12Constants;
import org.apache.cxf.ws.security.policy.SPConstants;
import org.apache.cxf.ws.security.policy.model.KeyValueToken;
import org.apache.neethi.Assertion;
import org.apache.neethi.AssertionBuilderFactory;
import org.apache.neethi.builders.AssertionBuilder;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class KeyValueTokenBuilder
implements AssertionBuilder<Element> {
    private static final String MS_NS = "http://schemas.microsoft.com/ws/2005/07/securitypolicy";
    private static final Logger LOG = LogUtils.getL7dLogger(KeyValueTokenBuilder.class);

    public Assertion build(Element element, AssertionBuilderFactory factory) {
        Element polEl;
        SPConstants consts = MS_NS.equals(element.getNamespaceURI()) ? SP11Constants.INSTANCE : SP12Constants.INSTANCE;
        KeyValueToken token = new KeyValueToken(consts);
        token.setOptional(PolicyConstants.isOptional((Element)element));
        token.setIgnorable(PolicyConstants.isIgnorable((Element)element));
        String attribute = element.getAttributeNS(element.getNamespaceURI(), "IncludeToken");
        if (StringUtils.isEmpty((String)attribute)) {
            attribute = element.getAttributeNS(consts.getNamespace(), "IncludeToken");
        }
        if (StringUtils.isEmpty((String)attribute)) {
            attribute = element.getAttributeNS(SP11Constants.INSTANCE.getNamespace(), "IncludeToken");
        }
        if (!StringUtils.isEmpty((String)attribute)) {
            token.setInclusion(consts.getInclusionFromAttributeValue(attribute));
        }
        if ((polEl = PolicyConstants.findPolicyElement((Element)element)) == null) {
            LOG.warning("sp:KeyValueToken/wsp:Policy should have a value!");
        } else {
            QName qname;
            token.setPolicy(polEl);
            Element child = DOMUtils.getFirstElement((Node)polEl);
            if (child != null && "RsaKeyValue".equals((qname = new QName(child.getNamespaceURI(), child.getLocalName())).getLocalPart())) {
                token.setForceRsaKeyValue(true);
            }
        }
        return token;
    }

    public QName[] getKnownElements() {
        return new QName[]{SP12Constants.KEYVALUE_TOKEN, new QName(MS_NS, "RsaToken")};
    }
}

