/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.policy.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.cxf.ws.security.policy.SP12Constants;
import org.apache.cxf.ws.security.policy.SPConstants;
import org.apache.cxf.ws.security.policy.model.AbstractSecurityAssertion;
import org.apache.neethi.PolicyComponent;

public class ContentEncryptedElements
extends AbstractSecurityAssertion {
    private List<String> xPathExpressions = new ArrayList<String>();
    private Map<String, String> declaredNamespaces = new HashMap<String, String>();
    private String xPathVersion;

    public ContentEncryptedElements(SPConstants version) {
        super(version);
    }

    public List<String> getXPathExpressions() {
        return this.xPathExpressions;
    }

    public void addXPathExpression(String expr) {
        this.xPathExpressions.add(expr);
    }

    public String getXPathVersion() {
        return this.xPathVersion;
    }

    public void setXPathVersion(String pathVersion) {
        this.xPathVersion = pathVersion;
    }

    public Map<String, String> getDeclaredNamespaces() {
        return this.declaredNamespaces;
    }

    public void addDeclaredNamespaces(String uri, String prefix) {
        this.declaredNamespaces.put(prefix, uri);
    }

    public void serialize(XMLStreamWriter writer) throws XMLStreamException {
        String prefix;
        String localName = this.getRealName().getLocalPart();
        String namespaceURI = this.getRealName().getNamespaceURI();
        String writerPrefix = writer.getPrefix(namespaceURI);
        if (writerPrefix == null) {
            prefix = this.getRealName().getPrefix();
            writer.setPrefix(prefix, namespaceURI);
        } else {
            prefix = writerPrefix;
        }
        writer.writeStartElement(prefix, localName, namespaceURI);
        writer.writeNamespace(prefix, namespaceURI);
        if (writerPrefix == null) {
            writer.writeNamespace(prefix, namespaceURI);
        }
        if (this.xPathVersion != null) {
            writer.writeAttribute(prefix, namespaceURI, "XPathVersion", this.xPathVersion);
        }
        for (String xpathExpression : this.xPathExpressions) {
            writer.writeStartElement(prefix, "XPath", namespaceURI);
            writer.writeCharacters(xpathExpression);
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    public QName getRealName() {
        return SP12Constants.CONTENT_ENCRYPTED_ELEMENTS;
    }

    public QName getName() {
        return SP12Constants.CONTENT_ENCRYPTED_ELEMENTS;
    }

    @Override
    public PolicyComponent normalize() {
        return this;
    }
}

