/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.policy.model;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.cxf.ws.policy.PolicyBuilder;
import org.apache.cxf.ws.security.policy.SP12Constants;
import org.apache.cxf.ws.security.policy.SPConstants;
import org.apache.cxf.ws.security.policy.model.Token;
import org.apache.cxf.ws.security.policy.model.TokenWrapper;

public class RecipientEncryptionToken
extends TokenWrapper {
    public RecipientEncryptionToken(SPConstants version, PolicyBuilder b) {
        super(version, b);
    }

    public Token getRecipientEncryptionToken() {
        return this.getToken();
    }

    public void setRecipientEncryptionToken(Token recipientEncryptionToken) {
        this.setToken(recipientEncryptionToken);
    }

    public QName getRealName() {
        return this.constants.getRecipientEncryptionToken();
    }

    public QName getName() {
        return SP12Constants.INSTANCE.getRecipientEncryptionToken();
    }

    public void serialize(XMLStreamWriter writer) throws XMLStreamException {
        String localName = this.getRealName().getLocalPart();
        String namespaceURI = this.getRealName().getNamespaceURI();
        String prefix = writer.getPrefix(namespaceURI);
        if (prefix == null) {
            prefix = this.getRealName().getPrefix();
            writer.setPrefix(prefix, namespaceURI);
        }
        writer.writeStartElement(prefix, localName, namespaceURI);
        String pPrefix = writer.getPrefix(SPConstants.POLICY.getNamespaceURI());
        if (pPrefix == null) {
            pPrefix = SPConstants.POLICY.getPrefix();
            writer.setPrefix(pPrefix, SPConstants.POLICY.getNamespaceURI());
        }
        writer.writeStartElement(pPrefix, SPConstants.POLICY.getLocalPart(), SPConstants.POLICY.getNamespaceURI());
        Token token = this.getRecipientEncryptionToken();
        if (token == null) {
            throw new RuntimeException("RecipientEncryptionToken doesn't contain any token assertions");
        }
        token.serialize(writer);
        writer.writeEndElement();
        writer.writeEndElement();
    }
}

