/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.wss4j.policyvalidators;

import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.ws.policy.AssertionInfo;
import org.apache.cxf.ws.policy.AssertionInfoMap;
import org.apache.cxf.ws.security.policy.SP12Constants;
import org.apache.cxf.ws.security.policy.model.X509Token;
import org.apache.cxf.ws.security.wss4j.WSS4JUtils;
import org.apache.cxf.ws.security.wss4j.policyvalidators.AbstractTokenPolicyValidator;
import org.apache.cxf.ws.security.wss4j.policyvalidators.TokenPolicyValidator;
import org.apache.ws.security.WSSecurityEngineResult;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.components.crypto.Merlin;
import org.apache.ws.security.message.token.BinarySecurity;
import org.apache.ws.security.message.token.X509Security;
import org.apache.ws.security.str.STRParser;
import org.apache.ws.security.util.WSSecurityUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class X509TokenPolicyValidator
extends AbstractTokenPolicyValidator
implements TokenPolicyValidator {
    private static final String X509_V3_VALUETYPE = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509v3";
    private static final String PKI_VALUETYPE = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509PKIPathv1";
    private static final Logger LOG = LogUtils.getL7dLogger(X509TokenPolicyValidator.class);

    @Override
    public boolean validatePolicy(AssertionInfoMap aim, Message message, Element soapBody, List<WSSecurityEngineResult> results, List<WSSecurityEngineResult> signedResults) {
        Collection ais = (Collection)aim.get((Object)SP12Constants.X509_TOKEN);
        if (ais == null || ais.isEmpty()) {
            return true;
        }
        List<WSSecurityEngineResult> bstResults = WSS4JUtils.fetchAllActionResults(results, 4096);
        for (AssertionInfo ai : ais) {
            X509Token x509TokenPolicy = (X509Token)ai.getAssertion();
            ai.setAsserted(true);
            if (!this.isTokenRequired(x509TokenPolicy, message)) continue;
            if (bstResults.isEmpty() && signedResults.isEmpty()) {
                ai.setNotAsserted("The received token does not match the token inclusion requirement");
                continue;
            }
            if (this.checkTokenType(x509TokenPolicy.getTokenVersionAndType(), bstResults, signedResults)) continue;
            ai.setNotAsserted("An incorrect X.509 Token Type is detected");
        }
        return true;
    }

    private boolean checkTokenType(String requiredVersionAndType, List<WSSecurityEngineResult> bstResults, List<WSSecurityEngineResult> signedResults) {
        if (bstResults.isEmpty() && signedResults.isEmpty()) {
            return false;
        }
        String requiredType = X509_V3_VALUETYPE;
        if ("WssX509PkiPathV1Token10".equals(requiredVersionAndType) || "WssX509PkiPathV1Token11".equals(requiredVersionAndType)) {
            requiredType = PKI_VALUETYPE;
        }
        for (WSSecurityEngineResult result : bstResults) {
            String type;
            BinarySecurity binarySecurityToken = (BinarySecurity)result.get((Object)"binary-security-token");
            if (binarySecurityToken == null || !requiredType.equals(type = binarySecurityToken.getValueType())) continue;
            return true;
        }
        if (X509_V3_VALUETYPE.equals(requiredType)) {
            for (WSSecurityEngineResult result : signedResults) {
                Element signatureElement;
                Element keyIdentifier;
                STRParser.REFERENCE_TYPE referenceType = (STRParser.REFERENCE_TYPE)result.get((Object)"x509-reference-type");
                if (STRParser.REFERENCE_TYPE.KEY_IDENTIFIER != referenceType || (keyIdentifier = this.getKeyIdentifier(signatureElement = (Element)result.get((Object)"token-element"))) == null || !X509_V3_VALUETYPE.equals(keyIdentifier.getAttributeNS(null, "ValueType"))) continue;
                try {
                    X509Security token = new X509Security(keyIdentifier, false);
                    X509Certificate cert = token.getX509Certificate((Crypto)new Merlin());
                    if (cert == null || cert.getVersion() != 3) continue;
                    return true;
                }
                catch (WSSecurityException e) {
                    LOG.log(Level.FINE, e.getMessage());
                }
            }
        }
        return false;
    }

    private Element getKeyIdentifier(Element signatureElement) {
        Element strElement;
        Element keyInfoElement;
        if (signatureElement != null && (keyInfoElement = WSSecurityUtil.getDirectChildElement((Node)signatureElement, (String)"KeyInfo", (String)"http://www.w3.org/2000/09/xmldsig#")) != null && (strElement = WSSecurityUtil.getDirectChildElement((Node)keyInfoElement, (String)"SecurityTokenReference", (String)"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd")) != null) {
            Element kiElement = WSSecurityUtil.getDirectChildElement((Node)strElement, (String)"KeyIdentifier", (String)"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd");
            return kiElement;
        }
        return null;
    }
}

