/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.hc.core5.http.NameValuePair;
import org.apache.hc.core5.util.LangUtils;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;

public class NameValuePairsMatcher
extends BaseMatcher<Collection<? extends NameValuePair>> {
    private final List<? extends NameValuePair> expectedNameValuePairList;

    public NameValuePairsMatcher(List<? extends NameValuePair> nameValuePairList) {
        this.expectedNameValuePairList = nameValuePairList;
    }

    public boolean matches(Object item) {
        Collection collection;
        if (item instanceof Collection && (collection = (Collection)item).size() == collection.size()) {
            int i = 0;
            for (Object obj : collection) {
                if (obj instanceof NameValuePair) {
                    NameValuePair nvp1 = (NameValuePair)obj;
                    NameValuePair nvp2 = this.expectedNameValuePairList.get(i);
                    if (!nvp1.getName().equalsIgnoreCase(nvp2.getName()) || !LangUtils.equals((Object)nvp1.getValue(), (Object)nvp2.getValue())) {
                        return false;
                    }
                } else {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public void describeTo(Description description) {
        description.appendText("same name/value pairs as ").appendValueList("[", ", ", "]", this.expectedNameValuePairList);
    }

    @Factory
    public static Matcher<Collection<? extends NameValuePair>> same(Collection<? extends NameValuePair> nameValuePairs) {
        return new NameValuePairsMatcher(new ArrayList<NameValuePair>(nameValuePairs));
    }

    @Factory
    public static Matcher<Collection<? extends NameValuePair>> same(NameValuePair ... nameValuePairs) {
        return new NameValuePairsMatcher(Arrays.asList(nameValuePairs));
    }
}

