/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.auth;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.apache.hc.client5.http.auth.BasicUserPrincipal;
import org.apache.hc.client5.http.auth.NTCredentials;
import org.apache.hc.client5.http.auth.NTUserPrincipal;
import org.apache.hc.client5.http.auth.UsernamePasswordCredentials;
import org.junit.Assert;
import org.junit.Test;

public class TestCredentials {
    @Test
    public void testUsernamePasswordCredentialsBasics() {
        UsernamePasswordCredentials creds1 = new UsernamePasswordCredentials("name", "pwd".toCharArray());
        Assert.assertEquals((Object)"name", (Object)creds1.getUserName());
        Assert.assertEquals((Object)new BasicUserPrincipal("name"), (Object)creds1.getUserPrincipal());
        Assert.assertArrayEquals((char[])"pwd".toCharArray(), (char[])creds1.getPassword());
        Assert.assertEquals((Object)"[principal: name]", (Object)creds1.toString());
        UsernamePasswordCredentials creds2 = new UsernamePasswordCredentials("name", null);
        Assert.assertEquals((Object)"name", (Object)creds2.getUserName());
        Assert.assertEquals((Object)new BasicUserPrincipal("name"), (Object)creds2.getUserPrincipal());
        Assert.assertEquals(null, (Object)creds2.getPassword());
        Assert.assertEquals((Object)"[principal: name]", (Object)creds2.toString());
    }

    @Test
    public void testNTCredentialsBasics() {
        NTCredentials creds1 = new NTCredentials("name", "pwd".toCharArray(), "localhost", "domain");
        Assert.assertEquals((Object)"name", (Object)creds1.getUserName());
        Assert.assertEquals((Object)new NTUserPrincipal("DOMAIN", "name"), (Object)creds1.getUserPrincipal());
        Assert.assertArrayEquals((char[])"pwd".toCharArray(), (char[])creds1.getPassword());
        Assert.assertEquals((Object)"[principal: DOMAIN\\name][workstation: LOCALHOST][netbiosDomain: DOMAIN]", (Object)creds1.toString());
        NTCredentials creds2 = new NTCredentials("name", null, null, null);
        Assert.assertEquals((Object)"name", (Object)creds2.getUserName());
        Assert.assertEquals((Object)new NTUserPrincipal(null, "name"), (Object)creds2.getUserPrincipal());
        Assert.assertEquals(null, (Object)creds2.getPassword());
        Assert.assertEquals((Object)"[principal: name][workstation: null][netbiosDomain: null]", (Object)creds2.toString());
    }

    @Test
    public void testUsernamePasswordCredentialsHashCode() {
        UsernamePasswordCredentials creds1 = new UsernamePasswordCredentials("name", "pwd".toCharArray());
        UsernamePasswordCredentials creds2 = new UsernamePasswordCredentials("othername", "pwd".toCharArray());
        UsernamePasswordCredentials creds3 = new UsernamePasswordCredentials("name", "otherpwd".toCharArray());
        Assert.assertTrue((creds1.hashCode() == creds1.hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((creds1.hashCode() != creds2.hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((creds1.hashCode() == creds3.hashCode() ? 1 : 0) != 0);
    }

    @Test
    public void testUsernamePasswordCredentialsEquals() {
        UsernamePasswordCredentials creds1 = new UsernamePasswordCredentials("name", "pwd".toCharArray());
        UsernamePasswordCredentials creds2 = new UsernamePasswordCredentials("othername", "pwd".toCharArray());
        UsernamePasswordCredentials creds3 = new UsernamePasswordCredentials("name", "otherpwd".toCharArray());
        Assert.assertTrue((boolean)creds1.equals((Object)creds1));
        Assert.assertFalse((boolean)creds1.equals((Object)creds2));
        Assert.assertTrue((boolean)creds1.equals((Object)creds3));
    }

    @Test
    public void testNTCredentialsHashCode() {
        NTCredentials creds1 = new NTCredentials("name", "pwd".toCharArray(), "somehost", "domain");
        NTCredentials creds2 = new NTCredentials("othername", "pwd".toCharArray(), "somehost", "domain");
        NTCredentials creds3 = new NTCredentials("name", "otherpwd".toCharArray(), "SomeHost", "Domain");
        NTCredentials creds4 = new NTCredentials("name", "pwd".toCharArray(), "otherhost", "domain");
        NTCredentials creds5 = new NTCredentials("name", "pwd".toCharArray(), null, "domain");
        NTCredentials creds6 = new NTCredentials("name", "pwd".toCharArray(), "somehost", "ms");
        NTCredentials creds7 = new NTCredentials("name", "pwd".toCharArray(), "somehost", null);
        NTCredentials creds8 = new NTCredentials("name", "pwd".toCharArray(), null, "domain");
        NTCredentials creds9 = new NTCredentials("name", "pwd".toCharArray(), "somehost", null);
        Assert.assertTrue((creds1.hashCode() == creds1.hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((creds1.hashCode() != creds2.hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((creds1.hashCode() == creds3.hashCode() ? 1 : 0) != 0);
        Assert.assertFalse((creds1.hashCode() == creds4.hashCode() ? 1 : 0) != 0);
        Assert.assertFalse((creds1.hashCode() == creds5.hashCode() ? 1 : 0) != 0);
        Assert.assertFalse((creds1.hashCode() == creds6.hashCode() ? 1 : 0) != 0);
        Assert.assertFalse((creds1.hashCode() == creds7.hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((creds8.hashCode() == creds5.hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((creds9.hashCode() == creds7.hashCode() ? 1 : 0) != 0);
    }

    @Test
    public void testNTCredentialsEquals() {
        NTCredentials creds1 = new NTCredentials("name", "pwd".toCharArray(), "somehost", "domain");
        NTCredentials creds2 = new NTCredentials("othername", "pwd".toCharArray(), "somehost", "domain");
        NTCredentials creds3 = new NTCredentials("name", "otherpwd".toCharArray(), "SomeHost", "Domain");
        NTCredentials creds4 = new NTCredentials("name", "pwd".toCharArray(), "otherhost", "domain");
        NTCredentials creds5 = new NTCredentials("name", "pwd".toCharArray(), null, "domain");
        NTCredentials creds6 = new NTCredentials("name", "pwd".toCharArray(), "somehost", "ms");
        NTCredentials creds7 = new NTCredentials("name", "pwd".toCharArray(), "somehost", null);
        NTCredentials creds8 = new NTCredentials("name", "pwd".toCharArray(), null, "domain");
        NTCredentials creds9 = new NTCredentials("name", "pwd".toCharArray(), "somehost", null);
        Assert.assertTrue((boolean)creds1.equals((Object)creds1));
        Assert.assertFalse((boolean)creds1.equals((Object)creds2));
        Assert.assertTrue((boolean)creds1.equals((Object)creds3));
        Assert.assertFalse((boolean)creds1.equals((Object)creds4));
        Assert.assertFalse((boolean)creds1.equals((Object)creds5));
        Assert.assertFalse((boolean)creds1.equals((Object)creds6));
        Assert.assertFalse((boolean)creds1.equals((Object)creds7));
        Assert.assertTrue((boolean)creds8.equals((Object)creds5));
        Assert.assertTrue((boolean)creds9.equals((Object)creds7));
    }

    @Test
    public void testUsernamePasswordCredentialsSerialization() throws Exception {
        UsernamePasswordCredentials orig = new UsernamePasswordCredentials("name", "pwd".toCharArray());
        ByteArrayOutputStream outbuffer = new ByteArrayOutputStream();
        ObjectOutputStream outStream = new ObjectOutputStream(outbuffer);
        outStream.writeObject(orig);
        outStream.close();
        byte[] raw = outbuffer.toByteArray();
        ByteArrayInputStream inBuffer = new ByteArrayInputStream(raw);
        ObjectInputStream inStream = new ObjectInputStream(inBuffer);
        UsernamePasswordCredentials clone = (UsernamePasswordCredentials)inStream.readObject();
        Assert.assertEquals((Object)orig, (Object)clone);
    }

    @Test
    public void testNTCredentialsSerialization() throws Exception {
        NTCredentials orig = new NTCredentials("name", "pwd".toCharArray(), "somehost", "domain");
        ByteArrayOutputStream outbuffer = new ByteArrayOutputStream();
        ObjectOutputStream outStream = new ObjectOutputStream(outbuffer);
        outStream.writeObject(orig);
        outStream.close();
        byte[] raw = outbuffer.toByteArray();
        ByteArrayInputStream inBuffer = new ByteArrayInputStream(raw);
        ObjectInputStream inStream = new ObjectInputStream(inBuffer);
        NTCredentials clone = (NTCredentials)inStream.readObject();
        Assert.assertEquals((Object)orig, (Object)clone);
    }
}

