/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.config;

import java.util.Collections;
import java.util.concurrent.TimeUnit;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.util.TimeValue;
import org.apache.hc.core5.util.Timeout;
import org.junit.Assert;
import org.junit.Test;

public class TestRequestConfig {
    @Test
    public void testBasics() {
        RequestConfig config = RequestConfig.custom().build();
        config.toString();
    }

    @Test
    public void testDefaults() {
        RequestConfig config = RequestConfig.DEFAULT;
        Assert.assertEquals((Object)Timeout.ofMinutes((long)3L), (Object)config.getConnectTimeout());
        Assert.assertEquals((Object)Timeout.ofMinutes((long)3L), (Object)config.getConnectionRequestTimeout());
        Assert.assertEquals((Object)false, (Object)config.isExpectContinueEnabled());
        Assert.assertEquals((Object)true, (Object)config.isAuthenticationEnabled());
        Assert.assertEquals((Object)true, (Object)config.isRedirectsEnabled());
        Assert.assertEquals((Object)false, (Object)config.isCircularRedirectsAllowed());
        Assert.assertEquals((long)50L, (long)config.getMaxRedirects());
        Assert.assertEquals(null, (Object)config.getCookieSpec());
        Assert.assertEquals(null, (Object)config.getProxy());
        Assert.assertEquals(null, (Object)config.getTargetPreferredAuthSchemes());
        Assert.assertEquals(null, (Object)config.getProxyPreferredAuthSchemes());
        Assert.assertEquals((Object)true, (Object)config.isContentCompressionEnabled());
    }

    @Test
    public void testBuildAndCopy() throws Exception {
        RequestConfig config0 = RequestConfig.custom().setConnectTimeout(33L, TimeUnit.MILLISECONDS).setConnectionRequestTimeout(44L, TimeUnit.MILLISECONDS).setExpectContinueEnabled(true).setAuthenticationEnabled(false).setRedirectsEnabled(false).setCircularRedirectsAllowed(true).setMaxRedirects(100).setCookieSpec("strict").setProxy(new HttpHost("someproxy")).setTargetPreferredAuthSchemes(Collections.singletonList("NTLM")).setProxyPreferredAuthSchemes(Collections.singletonList("Digest")).setContentCompressionEnabled(false).build();
        RequestConfig config = RequestConfig.copy((RequestConfig)config0).build();
        Assert.assertEquals((Object)TimeValue.ofMilliseconds((long)33L), (Object)config.getConnectTimeout());
        Assert.assertEquals((Object)TimeValue.ofMilliseconds((long)44L), (Object)config.getConnectionRequestTimeout());
        Assert.assertEquals((Object)true, (Object)config.isExpectContinueEnabled());
        Assert.assertEquals((Object)false, (Object)config.isAuthenticationEnabled());
        Assert.assertEquals((Object)false, (Object)config.isRedirectsEnabled());
        Assert.assertEquals((Object)true, (Object)config.isCircularRedirectsAllowed());
        Assert.assertEquals((long)100L, (long)config.getMaxRedirects());
        Assert.assertEquals((Object)"strict", (Object)config.getCookieSpec());
        Assert.assertEquals((Object)new HttpHost("someproxy"), (Object)config.getProxy());
        Assert.assertEquals(Collections.singletonList("NTLM"), (Object)config.getTargetPreferredAuthSchemes());
        Assert.assertEquals(Collections.singletonList("Digest"), (Object)config.getProxyPreferredAuthSchemes());
        Assert.assertEquals((Object)false, (Object)config.isContentCompressionEnabled());
    }
}

