/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.entity.mime;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.hc.client5.http.entity.mime.InputStreamBody;
import org.apache.hc.client5.http.entity.mime.StringBody;
import org.apache.hc.core5.http.ContentType;
import org.junit.Assert;
import org.junit.Test;

public class TestMultipartContentBody {
    @Test
    public void testStringBody() throws Exception {
        StringBody b1 = new StringBody("text", ContentType.DEFAULT_TEXT);
        Assert.assertEquals((long)4L, (long)b1.getContentLength());
        Assert.assertEquals((Object)"ISO-8859-1", (Object)b1.getCharset());
        Assert.assertNull((Object)b1.getFilename());
        Assert.assertEquals((Object)"text/plain", (Object)b1.getMimeType());
        Assert.assertEquals((Object)"text", (Object)b1.getMediaType());
        Assert.assertEquals((Object)"plain", (Object)b1.getSubType());
        StringBody b2 = new StringBody("more text", ContentType.create((String)"text/other", (Charset)StandardCharsets.ISO_8859_1));
        Assert.assertEquals((long)9L, (long)b2.getContentLength());
        Assert.assertEquals((Object)StandardCharsets.ISO_8859_1.name(), (Object)b2.getCharset());
        Assert.assertNull((Object)b2.getFilename());
        Assert.assertEquals((Object)"text/other", (Object)b2.getMimeType());
        Assert.assertEquals((Object)"text", (Object)b2.getMediaType());
        Assert.assertEquals((Object)"other", (Object)b2.getSubType());
    }

    @Test
    public void testInputStreamBody() throws Exception {
        byte[] stuff = "Stuff".getBytes(StandardCharsets.US_ASCII);
        InputStreamBody b1 = new InputStreamBody((InputStream)new ByteArrayInputStream(stuff), "stuff");
        Assert.assertEquals((long)-1L, (long)b1.getContentLength());
        Assert.assertNull((Object)b1.getCharset());
        Assert.assertEquals((Object)"stuff", (Object)b1.getFilename());
        Assert.assertEquals((Object)"application/octet-stream", (Object)b1.getMimeType());
        Assert.assertEquals((Object)"application", (Object)b1.getMediaType());
        Assert.assertEquals((Object)"octet-stream", (Object)b1.getSubType());
        InputStreamBody b2 = new InputStreamBody((InputStream)new ByteArrayInputStream(stuff), ContentType.create((String)"some/stuff"), "stuff");
        Assert.assertEquals((long)-1L, (long)b2.getContentLength());
        Assert.assertNull((Object)b2.getCharset());
        Assert.assertEquals((Object)"stuff", (Object)b2.getFilename());
        Assert.assertEquals((Object)"some/stuff", (Object)b2.getMimeType());
        Assert.assertEquals((Object)"some", (Object)b2.getMediaType());
        Assert.assertEquals((Object)"stuff", (Object)b2.getSubType());
    }
}

