/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.examples;

import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.hc.client5.http.async.methods.SimpleHttpRequest;
import org.apache.hc.client5.http.async.methods.SimpleHttpResponse;
import org.apache.hc.client5.http.async.methods.SimpleRequestBuilder;
import org.apache.hc.client5.http.async.methods.SimpleRequestProducer;
import org.apache.hc.client5.http.async.methods.SimpleResponseConsumer;
import org.apache.hc.client5.http.impl.async.CloseableHttpAsyncClient;
import org.apache.hc.client5.http.impl.async.HttpAsyncClients;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.message.StatusLine;
import org.apache.hc.core5.http.nio.AsyncRequestProducer;
import org.apache.hc.core5.http.nio.AsyncResponseConsumer;
import org.apache.hc.core5.io.CloseMode;
import org.apache.hc.core5.reactor.IOReactorConfig;
import org.apache.hc.core5.util.TimeValue;
import org.apache.hc.core5.util.Timeout;

public class AsyncClientConnectionEviction {
    public static void main(String[] args) throws Exception {
        IOReactorConfig ioReactorConfig = IOReactorConfig.custom().setSoTimeout(Timeout.ofSeconds((long)5L)).build();
        CloseableHttpAsyncClient client = HttpAsyncClients.custom().setIOReactorConfig(ioReactorConfig).evictExpiredConnections().evictIdleConnections(TimeValue.ofSeconds((long)10L)).build();
        client.start();
        final SimpleHttpRequest request = SimpleRequestBuilder.get().setHttpHost(new HttpHost("httpbin.org")).setPath("/").build();
        System.out.println("Executing request " + request);
        Future future1 = client.execute((AsyncRequestProducer)SimpleRequestProducer.create((SimpleHttpRequest)request), (AsyncResponseConsumer)SimpleResponseConsumer.create(), (FutureCallback)new FutureCallback<SimpleHttpResponse>(){

            public void completed(SimpleHttpResponse response) {
                System.out.println(request + "->" + new StatusLine((HttpResponse)response));
                System.out.println(response.getBody());
            }

            public void failed(Exception ex) {
                System.out.println(request + "->" + ex);
            }

            public void cancelled() {
                System.out.println(request + " cancelled");
            }
        });
        future1.get();
        Thread.sleep(TimeUnit.SECONDS.toMillis(30L));
        Future future2 = client.execute(request, (FutureCallback)new FutureCallback<SimpleHttpResponse>(){

            public void completed(SimpleHttpResponse response) {
                System.out.println(request + "->" + new StatusLine((HttpResponse)response));
                System.out.println(response.getBody());
            }

            public void failed(Exception ex) {
                System.out.println(request + "->" + ex);
            }

            public void cancelled() {
                System.out.println(request + " cancelled");
            }
        });
        future2.get();
        System.out.println("Shutting down");
        client.close(CloseMode.GRACEFUL);
    }
}

