/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.examples;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.Socket;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.client5.http.socket.ConnectionSocketFactory;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.config.Registry;
import org.apache.hc.core5.http.config.RegistryBuilder;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.util.TimeValue;

public class ClientExecuteSOCKS {
    public static void main(String[] args) throws Exception {
        Registry reg = RegistryBuilder.create().register("http", (Object)new MyConnectionSocketFactory()).build();
        PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager(reg);
        try (CloseableHttpClient httpclient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)cm).build();){
            InetSocketAddress socksaddr = new InetSocketAddress("mysockshost", 1234);
            HttpClientContext context = HttpClientContext.create();
            context.setAttribute("socks.address", (Object)socksaddr);
            HttpHost target = new HttpHost("http", "httpbin.org", 80);
            HttpGet request = new HttpGet("/get");
            System.out.println("Executing request " + request.getMethod() + " " + request.getUri() + " via SOCKS proxy " + socksaddr);
            try (CloseableHttpResponse response = httpclient.execute(target, (ClassicHttpRequest)request, (HttpContext)context);){
                System.out.println("----------------------------------------");
                System.out.println(response.getCode() + " " + response.getReasonPhrase());
                System.out.println(EntityUtils.toString((HttpEntity)response.getEntity()));
            }
        }
    }

    static class MyConnectionSocketFactory
    implements ConnectionSocketFactory {
        MyConnectionSocketFactory() {
        }

        public Socket createSocket(HttpContext context) throws IOException {
            InetSocketAddress socksaddr = (InetSocketAddress)context.getAttribute("socks.address");
            Proxy proxy = new Proxy(Proxy.Type.SOCKS, socksaddr);
            return new Socket(proxy);
        }

        public Socket connectSocket(TimeValue connectTimeout, Socket socket, HttpHost host, InetSocketAddress remoteAddress, InetSocketAddress localAddress, HttpContext context) throws IOException {
            Socket sock = socket != null ? socket : this.createSocket(context);
            if (localAddress != null) {
                sock.bind(localAddress);
            }
            sock.connect(remoteAddress, connectTimeout != null ? connectTimeout.toMillisecondsIntBound() : 0);
            return sock;
        }
    }
}

