/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.examples;

import io.reactivex.Flowable;
import io.reactivex.Notification;
import io.reactivex.Observable;
import io.reactivex.functions.Consumer;
import io.reactivex.functions.Function;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.hc.client5.http.impl.async.HttpAsyncClients;
import org.apache.hc.client5.http.impl.async.MinimalHttpAsyncClient;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.Message;
import org.apache.hc.core5.http.config.Http1Config;
import org.apache.hc.core5.http.nio.AsyncEntityProducer;
import org.apache.hc.core5.http.nio.AsyncRequestProducer;
import org.apache.hc.core5.http.nio.AsyncResponseConsumer;
import org.apache.hc.core5.http.nio.support.BasicRequestProducer;
import org.apache.hc.core5.http2.HttpVersionPolicy;
import org.apache.hc.core5.http2.config.H2Config;
import org.apache.hc.core5.io.CloseMode;
import org.apache.hc.core5.reactive.ReactiveEntityProducer;
import org.apache.hc.core5.reactive.ReactiveResponseConsumer;
import org.apache.hc.core5.reactor.IOReactorConfig;
import org.apache.hc.core5.util.Timeout;
import org.reactivestreams.Publisher;

public class ReactiveClientFullDuplexExchange {
    public static void main(String[] args) throws Exception {
        IOReactorConfig ioReactorConfig = IOReactorConfig.custom().setSoTimeout(Timeout.ofSeconds((long)5L)).build();
        MinimalHttpAsyncClient client = HttpAsyncClients.createMinimal((HttpVersionPolicy)HttpVersionPolicy.NEGOTIATE, (H2Config)H2Config.DEFAULT, (Http1Config)Http1Config.DEFAULT, (IOReactorConfig)ioReactorConfig);
        client.start();
        URI requestUri = new URI("http://httpbin.org/post");
        byte[] bs = "stuff".getBytes(StandardCharsets.UTF_8);
        ReactiveEntityProducer reactiveEntityProducer = new ReactiveEntityProducer((Publisher)Flowable.just((Object)ByteBuffer.wrap(bs)), (long)bs.length, ContentType.TEXT_PLAIN, null);
        BasicRequestProducer requestProducer = new BasicRequestProducer("POST", requestUri, (AsyncEntityProducer)reactiveEntityProducer);
        ReactiveResponseConsumer consumer = new ReactiveResponseConsumer();
        Future requestFuture = client.execute((AsyncRequestProducer)requestProducer, (AsyncResponseConsumer)consumer, null);
        Message streamingResponse = (Message)consumer.getResponseFuture().get();
        System.out.println(streamingResponse.getHead());
        for (Header header : ((HttpResponse)streamingResponse.getHead()).getHeaders()) {
            System.out.println(header);
        }
        System.out.println();
        Observable.fromPublisher((Publisher)((Publisher)streamingResponse.getBody())).map((Function)new Function<ByteBuffer, String>(){

            public String apply(ByteBuffer byteBuffer) throws Exception {
                byte[] string = new byte[byteBuffer.remaining()];
                byteBuffer.get(string);
                return new String(string);
            }
        }).materialize().forEach((Consumer)new Consumer<Notification<String>>(){

            public void accept(Notification<String> byteBufferNotification) throws Exception {
                System.out.println(byteBufferNotification);
            }
        });
        requestFuture.get(1L, TimeUnit.MINUTES);
        System.out.println("Shutting down");
        client.close(CloseMode.GRACEFUL);
    }
}

