/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.apache.hc.client5.http.auth.AuthChallenge;
import org.apache.hc.client5.http.auth.AuthScheme;
import org.apache.hc.client5.http.auth.AuthScope;
import org.apache.hc.client5.http.auth.ChallengeType;
import org.apache.hc.client5.http.auth.Credentials;
import org.apache.hc.client5.http.auth.CredentialsProvider;
import org.apache.hc.client5.http.auth.UsernamePasswordCredentials;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.DefaultAuthenticationStrategy;
import org.apache.hc.client5.http.impl.auth.BasicCredentialsProvider;
import org.apache.hc.client5.http.impl.auth.BasicScheme;
import org.apache.hc.client5.http.impl.auth.BasicSchemeFactory;
import org.apache.hc.client5.http.impl.auth.DigestScheme;
import org.apache.hc.client5.http.impl.auth.DigestSchemeFactory;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.core5.http.NameValuePair;
import org.apache.hc.core5.http.config.Lookup;
import org.apache.hc.core5.http.config.Registry;
import org.apache.hc.core5.http.config.RegistryBuilder;
import org.apache.hc.core5.http.message.BasicNameValuePair;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.junit.Assert;
import org.junit.Test;

public class TestAuthenticationStrategy {
    @Test
    public void testSelectInvalidInput() throws Exception {
        DefaultAuthenticationStrategy authStrategy = new DefaultAuthenticationStrategy();
        HttpClientContext context = HttpClientContext.create();
        try {
            authStrategy.select(null, Collections.emptyMap(), (HttpContext)context);
            Assert.fail((String)"NullPointerException expected");
        }
        catch (NullPointerException ex) {
            // empty catch block
        }
        try {
            authStrategy.select(ChallengeType.TARGET, null, (HttpContext)context);
            Assert.fail((String)"NullPointerException expected");
        }
        catch (NullPointerException ex) {
            // empty catch block
        }
        try {
            authStrategy.select(ChallengeType.TARGET, Collections.emptyMap(), null);
            Assert.fail((String)"NullPointerException expected");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testSelectNoSchemeRegistry() throws Exception {
        DefaultAuthenticationStrategy authStrategy = new DefaultAuthenticationStrategy();
        HttpClientContext context = HttpClientContext.create();
        HashMap<String, AuthChallenge> challenges = new HashMap<String, AuthChallenge>();
        challenges.put("Basic".toLowerCase(Locale.ROOT), new AuthChallenge(ChallengeType.TARGET, "Basic", new NameValuePair[]{new BasicNameValuePair("realm", "test")}));
        challenges.put("Digest".toLowerCase(Locale.ROOT), new AuthChallenge(ChallengeType.TARGET, "Digest", new NameValuePair[]{new BasicNameValuePair("realm", "test"), new BasicNameValuePair("nonce", "1234")}));
        List authSchemes = authStrategy.select(ChallengeType.TARGET, challenges, (HttpContext)context);
        Assert.assertNotNull((Object)authSchemes);
        Assert.assertEquals((long)0L, (long)authSchemes.size());
    }

    @Test
    public void testUnsupportedScheme() throws Exception {
        DefaultAuthenticationStrategy authStrategy = new DefaultAuthenticationStrategy();
        HttpClientContext context = HttpClientContext.create();
        HashMap<String, AuthChallenge> challenges = new HashMap<String, AuthChallenge>();
        challenges.put("Basic".toLowerCase(Locale.ROOT), new AuthChallenge(ChallengeType.TARGET, "Basic", new NameValuePair[]{new BasicNameValuePair("realm", "realm1")}));
        challenges.put("Digest".toLowerCase(Locale.ROOT), new AuthChallenge(ChallengeType.TARGET, "Digest", new NameValuePair[]{new BasicNameValuePair("realm", "realm2"), new BasicNameValuePair("nonce", "1234")}));
        challenges.put("whatever", new AuthChallenge(ChallengeType.TARGET, "Whatever", new NameValuePair[]{new BasicNameValuePair("realm", "realm3")}));
        Registry authSchemeRegistry = RegistryBuilder.create().register("Basic", (Object)BasicSchemeFactory.INSTANCE).register("Digest", (Object)DigestSchemeFactory.INSTANCE).build();
        context.setAuthSchemeRegistry((Lookup)authSchemeRegistry);
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        credentialsProvider.setCredentials(new AuthScope("somehost", 80), (Credentials)new UsernamePasswordCredentials("user", "pwd".toCharArray()));
        context.setCredentialsProvider((CredentialsProvider)credentialsProvider);
        List authSchemes = authStrategy.select(ChallengeType.TARGET, challenges, (HttpContext)context);
        Assert.assertNotNull((Object)authSchemes);
        Assert.assertEquals((long)2L, (long)authSchemes.size());
        AuthScheme authScheme1 = (AuthScheme)authSchemes.get(0);
        Assert.assertTrue((boolean)(authScheme1 instanceof DigestScheme));
        AuthScheme authScheme2 = (AuthScheme)authSchemes.get(1);
        Assert.assertTrue((boolean)(authScheme2 instanceof BasicScheme));
    }

    @Test
    public void testCustomAuthPreference() throws Exception {
        DefaultAuthenticationStrategy authStrategy = new DefaultAuthenticationStrategy();
        RequestConfig config = RequestConfig.custom().setTargetPreferredAuthSchemes(Collections.singletonList("Basic")).build();
        HttpClientContext context = HttpClientContext.create();
        HashMap<String, AuthChallenge> challenges = new HashMap<String, AuthChallenge>();
        challenges.put("Basic".toLowerCase(Locale.ROOT), new AuthChallenge(ChallengeType.TARGET, "Basic", new NameValuePair[]{new BasicNameValuePair("realm", "realm1")}));
        challenges.put("Digest".toLowerCase(Locale.ROOT), new AuthChallenge(ChallengeType.TARGET, "Digest", new NameValuePair[]{new BasicNameValuePair("realm", "realm2"), new BasicNameValuePair("nonce", "1234")}));
        Registry authSchemeRegistry = RegistryBuilder.create().register("Basic", (Object)BasicSchemeFactory.INSTANCE).register("Digest", (Object)DigestSchemeFactory.INSTANCE).build();
        context.setAuthSchemeRegistry((Lookup)authSchemeRegistry);
        context.setRequestConfig(config);
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        credentialsProvider.setCredentials(new AuthScope("somehost", 80), (Credentials)new UsernamePasswordCredentials("user", "pwd".toCharArray()));
        context.setCredentialsProvider((CredentialsProvider)credentialsProvider);
        List authSchemes = authStrategy.select(ChallengeType.TARGET, challenges, (HttpContext)context);
        Assert.assertNotNull((Object)authSchemes);
        Assert.assertEquals((long)1L, (long)authSchemes.size());
        AuthScheme authScheme1 = (AuthScheme)authSchemes.get(0);
        Assert.assertTrue((boolean)(authScheme1 instanceof BasicScheme));
    }
}

