/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl;

import java.io.IOException;
import java.net.ConnectException;
import java.net.NoRouteToHostException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.Date;
import javax.net.ssl.SSLException;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.impl.DefaultHttpRequestRetryStrategy;
import org.apache.hc.client5.http.utils.DateUtils;
import org.apache.hc.core5.http.ConnectionClosedException;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.message.BasicHttpResponse;
import org.apache.hc.core5.util.TimeValue;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestDefaultHttpRequestRetryStrategy {
    private DefaultHttpRequestRetryStrategy retryStrategy;

    @Before
    public void setup() {
        this.retryStrategy = new DefaultHttpRequestRetryStrategy(3, TimeValue.ofMilliseconds((long)1234L));
    }

    @Test
    public void testBasics() throws Exception {
        BasicHttpResponse response1 = new BasicHttpResponse(503, "Oopsie");
        Assert.assertTrue((boolean)this.retryStrategy.retryRequest((HttpResponse)response1, 1, null));
        Assert.assertTrue((boolean)this.retryStrategy.retryRequest((HttpResponse)response1, 2, null));
        Assert.assertTrue((boolean)this.retryStrategy.retryRequest((HttpResponse)response1, 3, null));
        Assert.assertFalse((boolean)this.retryStrategy.retryRequest((HttpResponse)response1, 4, null));
        BasicHttpResponse response2 = new BasicHttpResponse(500, "Big Time Oopsie");
        Assert.assertFalse((boolean)this.retryStrategy.retryRequest((HttpResponse)response2, 1, null));
        BasicHttpResponse response3 = new BasicHttpResponse(429, "Oopsie");
        Assert.assertTrue((boolean)this.retryStrategy.retryRequest((HttpResponse)response3, 1, null));
        Assert.assertTrue((boolean)this.retryStrategy.retryRequest((HttpResponse)response3, 2, null));
        Assert.assertTrue((boolean)this.retryStrategy.retryRequest((HttpResponse)response3, 3, null));
        Assert.assertFalse((boolean)this.retryStrategy.retryRequest((HttpResponse)response3, 4, null));
        Assert.assertEquals((Object)TimeValue.ofMilliseconds((long)1234L), (Object)this.retryStrategy.getRetryInterval((HttpResponse)response1, 1, null));
    }

    @Test
    public void testRetryAfterHeaderAsLong() throws Exception {
        BasicHttpResponse response = new BasicHttpResponse(503, "Oopsie");
        response.setHeader("Retry-After", (Object)"321");
        Assert.assertEquals((Object)TimeValue.ofSeconds((long)321L), (Object)this.retryStrategy.getRetryInterval((HttpResponse)response, 3, null));
    }

    @Test
    public void testRetryAfterHeaderAsDate() throws Exception {
        this.retryStrategy = new DefaultHttpRequestRetryStrategy(3, TimeValue.ZERO_MILLISECONDS);
        BasicHttpResponse response = new BasicHttpResponse(503, "Oopsie");
        response.setHeader("Retry-After", (Object)DateUtils.formatDate((Date)new Date(System.currentTimeMillis() + 100000L)));
        Assert.assertTrue((this.retryStrategy.getRetryInterval((HttpResponse)response, 3, null).compareTo(TimeValue.ZERO_MILLISECONDS) > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testRetryAfterHeaderAsPastDate() throws Exception {
        BasicHttpResponse response = new BasicHttpResponse(503, "Oopsie");
        response.setHeader("Retry-After", (Object)DateUtils.formatDate((Date)new Date(System.currentTimeMillis() - 100000L)));
        Assert.assertEquals((Object)TimeValue.ofMilliseconds((long)1234L), (Object)this.retryStrategy.getRetryInterval((HttpResponse)response, 3, null));
    }

    @Test
    public void testInvalidRetryAfterHeader() throws Exception {
        BasicHttpResponse response = new BasicHttpResponse(503, "Oopsie");
        response.setHeader("Retry-After", (Object)"Stuff");
        Assert.assertEquals((Object)TimeValue.ofMilliseconds((long)1234L), (Object)this.retryStrategy.getRetryInterval((HttpResponse)response, 3, null));
    }

    @Test
    public void noRetryOnConnectTimeout() throws Exception {
        HttpGet request = new HttpGet("/");
        Assert.assertFalse((boolean)this.retryStrategy.retryRequest((HttpRequest)request, (IOException)new SocketTimeoutException(), 1, null));
    }

    @Test
    public void noRetryOnConnect() throws Exception {
        HttpGet request = new HttpGet("/");
        Assert.assertFalse((boolean)this.retryStrategy.retryRequest((HttpRequest)request, (IOException)new ConnectException(), 1, null));
    }

    @Test
    public void noRetryOnConnectionClosed() throws Exception {
        HttpGet request = new HttpGet("/");
        Assert.assertFalse((boolean)this.retryStrategy.retryRequest((HttpRequest)request, (IOException)new ConnectionClosedException(), 1, null));
    }

    @Test
    public void noRetryForNoRouteToHostException() {
        HttpGet request = new HttpGet("/");
        Assert.assertFalse((boolean)this.retryStrategy.retryRequest((HttpRequest)request, (IOException)new NoRouteToHostException(), 1, null));
    }

    @Test
    public void noRetryOnSSLFailure() throws Exception {
        HttpGet request = new HttpGet("/");
        Assert.assertFalse((boolean)this.retryStrategy.retryRequest((HttpRequest)request, (IOException)new SSLException("encryption failed"), 1, null));
    }

    @Test
    public void noRetryOnUnknownHost() throws Exception {
        HttpGet request = new HttpGet("/");
        Assert.assertFalse((boolean)this.retryStrategy.retryRequest((HttpRequest)request, (IOException)new UnknownHostException(), 1, null));
    }

    @Test
    public void noRetryOnAbortedRequests() throws Exception {
        HttpGet request = new HttpGet("/");
        request.cancel();
        Assert.assertFalse((boolean)this.retryStrategy.retryRequest((HttpRequest)request, new IOException(), 1, null));
    }

    @Test
    public void retryOnNonAbortedRequests() throws Exception {
        HttpGet request = new HttpGet("/");
        Assert.assertTrue((boolean)this.retryStrategy.retryRequest((HttpRequest)request, new IOException(), 1, null));
    }
}

