/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl;

import java.net.URI;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.impl.DefaultRedirectStrategy;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.ProtocolException;
import org.apache.hc.core5.http.message.BasicHttpResponse;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.junit.Assert;
import org.junit.Test;

public class TestDefaultRedirectStrategy {
    @Test
    public void testIsRedirectedMovedTemporary() throws Exception {
        DefaultRedirectStrategy redirectStrategy = new DefaultRedirectStrategy();
        HttpClientContext context = HttpClientContext.create();
        HttpGet httpget = new HttpGet("http://localhost/");
        BasicHttpResponse response = new BasicHttpResponse(302, "Redirect");
        Assert.assertFalse((boolean)redirectStrategy.isRedirected((HttpRequest)httpget, (HttpResponse)response, (HttpContext)context));
        response.setHeader("Location", (Object)"http://localhost/blah");
        Assert.assertTrue((boolean)redirectStrategy.isRedirected((HttpRequest)httpget, (HttpResponse)response, (HttpContext)context));
    }

    @Test
    public void testIsRedirectedMovedTemporaryNoLocation() throws Exception {
        DefaultRedirectStrategy redirectStrategy = new DefaultRedirectStrategy();
        HttpClientContext context = HttpClientContext.create();
        HttpGet httpget = new HttpGet("http://localhost/");
        BasicHttpResponse response = new BasicHttpResponse(302, "Redirect");
        Assert.assertFalse((boolean)redirectStrategy.isRedirected((HttpRequest)httpget, (HttpResponse)response, (HttpContext)context));
    }

    @Test
    public void testIsRedirectedMovedPermanently() throws Exception {
        DefaultRedirectStrategy redirectStrategy = new DefaultRedirectStrategy();
        HttpClientContext context = HttpClientContext.create();
        HttpGet httpget = new HttpGet("http://localhost/");
        BasicHttpResponse response = new BasicHttpResponse(301, "Redirect");
        Assert.assertFalse((boolean)redirectStrategy.isRedirected((HttpRequest)httpget, (HttpResponse)response, (HttpContext)context));
        response.setHeader("Location", (Object)"http://localhost/blah");
        Assert.assertTrue((boolean)redirectStrategy.isRedirected((HttpRequest)httpget, (HttpResponse)response, (HttpContext)context));
    }

    @Test
    public void testIsRedirectedTemporaryRedirect() throws Exception {
        DefaultRedirectStrategy redirectStrategy = new DefaultRedirectStrategy();
        HttpClientContext context = HttpClientContext.create();
        HttpGet httpget = new HttpGet("http://localhost/");
        BasicHttpResponse response = new BasicHttpResponse(307, "Redirect");
        Assert.assertFalse((boolean)redirectStrategy.isRedirected((HttpRequest)httpget, (HttpResponse)response, (HttpContext)context));
        response.setHeader("Location", (Object)"http://localhost/blah");
        Assert.assertTrue((boolean)redirectStrategy.isRedirected((HttpRequest)httpget, (HttpResponse)response, (HttpContext)context));
    }

    @Test
    public void testIsRedirectedSeeOther() throws Exception {
        DefaultRedirectStrategy redirectStrategy = new DefaultRedirectStrategy();
        HttpClientContext context = HttpClientContext.create();
        HttpGet httpget = new HttpGet("http://localhost/");
        BasicHttpResponse response = new BasicHttpResponse(303, "Redirect");
        Assert.assertFalse((boolean)redirectStrategy.isRedirected((HttpRequest)httpget, (HttpResponse)response, (HttpContext)context));
        response.setHeader("Location", (Object)"http://localhost/blah");
        Assert.assertTrue((boolean)redirectStrategy.isRedirected((HttpRequest)httpget, (HttpResponse)response, (HttpContext)context));
    }

    @Test
    public void testIsRedirectedUnknownStatus() throws Exception {
        DefaultRedirectStrategy redirectStrategy = new DefaultRedirectStrategy();
        HttpClientContext context = HttpClientContext.create();
        HttpGet httpget = new HttpGet("http://localhost/");
        BasicHttpResponse response = new BasicHttpResponse(333, "Redirect");
        Assert.assertFalse((boolean)redirectStrategy.isRedirected((HttpRequest)httpget, (HttpResponse)response, (HttpContext)context));
        HttpPost httppost = new HttpPost("http://localhost/");
        Assert.assertFalse((boolean)redirectStrategy.isRedirected((HttpRequest)httppost, (HttpResponse)response, (HttpContext)context));
    }

    @Test
    public void testIsRedirectedInvalidInput() throws Exception {
        DefaultRedirectStrategy redirectStrategy = new DefaultRedirectStrategy();
        HttpClientContext context = HttpClientContext.create();
        HttpGet httpget = new HttpGet("http://localhost/");
        BasicHttpResponse response = new BasicHttpResponse(303, "Redirect");
        try {
            redirectStrategy.isRedirected(null, (HttpResponse)response, (HttpContext)context);
            Assert.fail((String)"NullPointerException expected");
        }
        catch (NullPointerException expected) {
            // empty catch block
        }
        try {
            redirectStrategy.isRedirected((HttpRequest)httpget, null, (HttpContext)context);
            Assert.fail((String)"NullPointerException expected");
        }
        catch (NullPointerException expected) {
            // empty catch block
        }
    }

    @Test
    public void testGetLocationUri() throws Exception {
        DefaultRedirectStrategy redirectStrategy = new DefaultRedirectStrategy();
        HttpClientContext context = HttpClientContext.create();
        HttpGet httpget = new HttpGet("http://localhost/");
        BasicHttpResponse response = new BasicHttpResponse(302, "Redirect");
        response.addHeader("Location", (Object)"http://localhost/stuff");
        URI uri = redirectStrategy.getLocationURI((HttpRequest)httpget, (HttpResponse)response, (HttpContext)context);
        Assert.assertEquals((Object)URI.create("http://localhost/stuff"), (Object)uri);
    }

    @Test(expected=HttpException.class)
    public void testGetLocationUriMissingHeader() throws Exception {
        DefaultRedirectStrategy redirectStrategy = new DefaultRedirectStrategy();
        HttpClientContext context = HttpClientContext.create();
        HttpGet httpget = new HttpGet("http://localhost/");
        BasicHttpResponse response = new BasicHttpResponse(302, "Redirect");
        redirectStrategy.getLocationURI((HttpRequest)httpget, (HttpResponse)response, (HttpContext)context);
    }

    @Test(expected=ProtocolException.class)
    public void testGetLocationUriInvalidLocation() throws Exception {
        DefaultRedirectStrategy redirectStrategy = new DefaultRedirectStrategy();
        HttpClientContext context = HttpClientContext.create();
        HttpGet httpget = new HttpGet("http://localhost/");
        BasicHttpResponse response = new BasicHttpResponse(302, "Redirect");
        response.addHeader("Location", (Object)"http://localhost/not valid");
        redirectStrategy.getLocationURI((HttpRequest)httpget, (HttpResponse)response, (HttpContext)context);
    }

    @Test
    public void testGetLocationUriRelative() throws Exception {
        DefaultRedirectStrategy redirectStrategy = new DefaultRedirectStrategy();
        HttpClientContext context = HttpClientContext.create();
        HttpGet httpget = new HttpGet("http://localhost/");
        BasicHttpResponse response = new BasicHttpResponse(302, "Redirect");
        response.addHeader("Location", (Object)"/stuff");
        URI uri = redirectStrategy.getLocationURI((HttpRequest)httpget, (HttpResponse)response, (HttpContext)context);
        Assert.assertEquals((Object)URI.create("http://localhost/stuff"), (Object)uri);
    }

    @Test
    public void testGetLocationUriRelativeWithFragment() throws Exception {
        DefaultRedirectStrategy redirectStrategy = new DefaultRedirectStrategy();
        HttpClientContext context = HttpClientContext.create();
        HttpGet httpget = new HttpGet("http://localhost/");
        BasicHttpResponse response = new BasicHttpResponse(302, "Redirect");
        response.addHeader("Location", (Object)"/stuff#fragment");
        URI uri = redirectStrategy.getLocationURI((HttpRequest)httpget, (HttpResponse)response, (HttpContext)context);
        Assert.assertEquals((Object)URI.create("http://localhost/stuff#fragment"), (Object)uri);
    }

    @Test
    public void testGetLocationUriAbsoluteWithFragment() throws Exception {
        DefaultRedirectStrategy redirectStrategy = new DefaultRedirectStrategy();
        HttpClientContext context = HttpClientContext.create();
        HttpGet httpget = new HttpGet("http://localhost/");
        BasicHttpResponse response = new BasicHttpResponse(302, "Redirect");
        response.addHeader("Location", (Object)"http://localhost/stuff#fragment");
        URI uri = redirectStrategy.getLocationURI((HttpRequest)httpget, (HttpResponse)response, (HttpContext)context);
        Assert.assertEquals((Object)URI.create("http://localhost/stuff#fragment"), (Object)uri);
    }

    @Test
    public void testGetLocationUriNormalized() throws Exception {
        DefaultRedirectStrategy redirectStrategy = new DefaultRedirectStrategy();
        HttpClientContext context = HttpClientContext.create();
        HttpGet httpget = new HttpGet("http://localhost/");
        BasicHttpResponse response = new BasicHttpResponse(302, "Redirect");
        response.addHeader("Location", (Object)"http://localhost/././stuff/../morestuff");
        URI uri = redirectStrategy.getLocationURI((HttpRequest)httpget, (HttpResponse)response, (HttpContext)context);
        Assert.assertEquals((Object)URI.create("http://localhost/morestuff"), (Object)uri);
    }

    @Test
    public void testGetLocationUriInvalidInput() throws Exception {
        DefaultRedirectStrategy redirectStrategy = new DefaultRedirectStrategy();
        HttpClientContext context = HttpClientContext.create();
        HttpGet httpget = new HttpGet("http://localhost/");
        BasicHttpResponse response = new BasicHttpResponse(302, "Redirect");
        response.addHeader("Location", (Object)"http://localhost/stuff");
        try {
            redirectStrategy.getLocationURI(null, (HttpResponse)response, (HttpContext)context);
            Assert.fail((String)"NullPointerException expected");
        }
        catch (NullPointerException expected) {
            // empty catch block
        }
        try {
            redirectStrategy.getLocationURI((HttpRequest)httpget, null, (HttpContext)context);
            Assert.fail((String)"NullPointerException expected");
        }
        catch (NullPointerException expected) {
            // empty catch block
        }
        try {
            redirectStrategy.getLocationURI((HttpRequest)httpget, (HttpResponse)response, null);
            Assert.fail((String)"NullPointerException expected");
        }
        catch (NullPointerException expected) {
            // empty catch block
        }
    }

    @Test
    public void testCreateLocationURI() throws Exception {
        DefaultRedirectStrategy redirectStrategy = new DefaultRedirectStrategy();
        Assert.assertEquals((Object)"http://blahblah/", (Object)redirectStrategy.createLocationURI("http://BlahBlah").toASCIIString());
    }

    @Test(expected=ProtocolException.class)
    public void testCreateLocationURIInvalid() throws Exception {
        DefaultRedirectStrategy redirectStrategy = new DefaultRedirectStrategy();
        redirectStrategy.createLocationURI(":::::::");
    }
}

