/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl;

import org.apache.hc.client5.http.impl.IdleConnectionEvictor;
import org.apache.hc.core5.pool.ConnPoolControl;
import org.apache.hc.core5.util.TimeValue;
import org.apache.hc.core5.util.Timeout;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestIdleConnectionEvictor {
    @Test
    public void testEvictExpiredAndIdle() throws Exception {
        ConnPoolControl cm = (ConnPoolControl)Mockito.mock(ConnPoolControl.class);
        IdleConnectionEvictor connectionEvictor = new IdleConnectionEvictor(cm, TimeValue.ofMilliseconds((long)500L), TimeValue.ofSeconds((long)3L));
        connectionEvictor.start();
        Thread.sleep(1000L);
        ((ConnPoolControl)Mockito.verify((Object)cm, (VerificationMode)Mockito.atLeast((int)1))).closeExpired();
        ((ConnPoolControl)Mockito.verify((Object)cm, (VerificationMode)Mockito.atLeast((int)1))).closeIdle(TimeValue.ofSeconds((long)3L));
        Assert.assertTrue((boolean)connectionEvictor.isRunning());
        connectionEvictor.shutdown();
        connectionEvictor.awaitTermination(Timeout.ofSeconds((long)1L));
        Assert.assertFalse((boolean)connectionEvictor.isRunning());
    }

    @Test
    public void testEvictExpiredOnly() throws Exception {
        ConnPoolControl cm = (ConnPoolControl)Mockito.mock(ConnPoolControl.class);
        IdleConnectionEvictor connectionEvictor = new IdleConnectionEvictor(cm, TimeValue.ofMilliseconds((long)500L), null);
        connectionEvictor.start();
        Thread.sleep(1000L);
        ((ConnPoolControl)Mockito.verify((Object)cm, (VerificationMode)Mockito.atLeast((int)1))).closeExpired();
        ((ConnPoolControl)Mockito.verify((Object)cm, (VerificationMode)Mockito.never())).closeIdle((TimeValue)ArgumentMatchers.any());
        Assert.assertTrue((boolean)connectionEvictor.isRunning());
        connectionEvictor.shutdown();
        connectionEvictor.awaitTermination(Timeout.ofSeconds((long)1L));
        Assert.assertFalse((boolean)connectionEvictor.isRunning());
    }
}

