/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.auth;

import org.apache.hc.client5.http.auth.AuthScheme;
import org.apache.hc.client5.http.impl.auth.BasicAuthCache;
import org.apache.hc.client5.http.impl.auth.BasicScheme;
import org.apache.hc.client5.http.impl.auth.NTLMScheme;
import org.apache.hc.core5.http.HttpHost;
import org.junit.Assert;
import org.junit.Test;

public class TestBasicAuthCache {
    @Test
    public void testBasicStoreRestore() throws Exception {
        BasicAuthCache cache = new BasicAuthCache();
        BasicScheme authScheme = new BasicScheme();
        cache.put(new HttpHost("localhost", 80), (AuthScheme)authScheme);
        Assert.assertNotNull((Object)cache.get(new HttpHost("localhost", 80)));
        cache.remove(new HttpHost("localhost", 80));
        Assert.assertNull((Object)cache.get(new HttpHost("localhost", 80)));
        cache.put(new HttpHost("localhost", 80), (AuthScheme)authScheme);
        cache.clear();
        Assert.assertNull((Object)cache.get(new HttpHost("localhost", 80)));
    }

    @Test(expected=NullPointerException.class)
    public void testNullKey() throws Exception {
        BasicAuthCache cache = new BasicAuthCache();
        BasicScheme authScheme = new BasicScheme();
        cache.put(null, (AuthScheme)authScheme);
    }

    @Test
    public void testNullAuthScheme() throws Exception {
        BasicAuthCache cache = new BasicAuthCache();
        cache.put(new HttpHost("localhost", 80), null);
        Assert.assertNull((Object)cache.get(new HttpHost("localhost", 80)));
    }

    @Test
    public void testStoreNonserializable() throws Exception {
        BasicAuthCache cache = new BasicAuthCache();
        NTLMScheme authScheme = new NTLMScheme();
        cache.put(new HttpHost("localhost", 80), (AuthScheme)authScheme);
        Assert.assertNull((Object)cache.get(new HttpHost("localhost", 80)));
    }
}

