/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.auth;

import org.apache.hc.client5.http.auth.AuthScope;
import org.apache.hc.client5.http.auth.Credentials;
import org.apache.hc.client5.http.auth.UsernamePasswordCredentials;
import org.apache.hc.client5.http.impl.auth.BasicCredentialsProvider;
import org.apache.hc.core5.http.HttpHost;
import org.junit.Assert;
import org.junit.Test;

public class TestBasicCredentialsProvider {
    public static final Credentials CREDS1 = new UsernamePasswordCredentials("user1", "pass1".toCharArray());
    public static final Credentials CREDS2 = new UsernamePasswordCredentials("user2", "pass2".toCharArray());
    public static final AuthScope SCOPE1 = new AuthScope(null, null, -1, "realm1", null);
    public static final AuthScope SCOPE2 = new AuthScope(null, null, -1, "realm2", null);
    public static final AuthScope BOGUS = new AuthScope(null, null, -1, "bogus", null);
    public static final AuthScope DEFSCOPE = new AuthScope(null, "host", -1, "realm", null);

    @Test
    public void testBasicCredentialsProviderCredentials() {
        BasicCredentialsProvider state = new BasicCredentialsProvider();
        state.setCredentials(SCOPE1, CREDS1);
        state.setCredentials(SCOPE2, CREDS2);
        Assert.assertEquals((Object)CREDS1, (Object)state.getCredentials(SCOPE1, null));
        Assert.assertEquals((Object)CREDS2, (Object)state.getCredentials(SCOPE2, null));
    }

    @Test
    public void testBasicCredentialsProviderNoCredentials() {
        BasicCredentialsProvider state = new BasicCredentialsProvider();
        Assert.assertEquals(null, (Object)state.getCredentials(BOGUS, null));
    }

    @Test
    public void testBasicCredentialsProviderDefaultCredentials() {
        BasicCredentialsProvider state = new BasicCredentialsProvider();
        state.setCredentials(new AuthScope(null, null, -1, null, null), CREDS1);
        state.setCredentials(SCOPE2, CREDS2);
        Assert.assertEquals((Object)CREDS1, (Object)state.getCredentials(BOGUS, null));
    }

    @Test
    public void testDefaultCredentials() throws Exception {
        BasicCredentialsProvider state = new BasicCredentialsProvider();
        UsernamePasswordCredentials expected = new UsernamePasswordCredentials("name", "pass".toCharArray());
        state.setCredentials(new AuthScope(null, null, -1, null, null), (Credentials)expected);
        Credentials got = state.getCredentials(DEFSCOPE, null);
        Assert.assertEquals((Object)got, (Object)expected);
    }

    @Test
    public void testRealmCredentials() throws Exception {
        BasicCredentialsProvider state = new BasicCredentialsProvider();
        UsernamePasswordCredentials expected = new UsernamePasswordCredentials("name", "pass".toCharArray());
        state.setCredentials(DEFSCOPE, (Credentials)expected);
        Credentials got = state.getCredentials(DEFSCOPE, null);
        Assert.assertEquals((Object)expected, (Object)got);
    }

    @Test
    public void testHostCredentials() throws Exception {
        BasicCredentialsProvider state = new BasicCredentialsProvider();
        UsernamePasswordCredentials expected = new UsernamePasswordCredentials("name", "pass".toCharArray());
        state.setCredentials(new AuthScope(null, "host", -1, null, null), (Credentials)expected);
        Credentials got = state.getCredentials(DEFSCOPE, null);
        Assert.assertEquals((Object)expected, (Object)got);
    }

    @Test
    public void testWrongHostCredentials() throws Exception {
        BasicCredentialsProvider state = new BasicCredentialsProvider();
        UsernamePasswordCredentials expected = new UsernamePasswordCredentials("name", "pass".toCharArray());
        state.setCredentials(new AuthScope(null, "host1", -1, "realm", null), (Credentials)expected);
        Credentials got = state.getCredentials(new AuthScope(null, "host2", -1, "realm", null), null);
        Assert.assertNotSame((Object)expected, (Object)got);
    }

    @Test
    public void testWrongRealmCredentials() throws Exception {
        BasicCredentialsProvider state = new BasicCredentialsProvider();
        UsernamePasswordCredentials cred = new UsernamePasswordCredentials("name", "pass".toCharArray());
        state.setCredentials(new AuthScope(null, "host", -1, "realm1", null), (Credentials)cred);
        Credentials got = state.getCredentials(new AuthScope(null, "host", -1, "realm2", null), null);
        Assert.assertNotSame((Object)cred, (Object)got);
    }

    @Test
    public void testMixedCaseHostname() throws Exception {
        HttpHost httpHost = new HttpHost("hOsT", 80);
        BasicCredentialsProvider state = new BasicCredentialsProvider();
        UsernamePasswordCredentials expected = new UsernamePasswordCredentials("name", "pass".toCharArray());
        state.setCredentials(new AuthScope(httpHost), (Credentials)expected);
        Credentials got = state.getCredentials(DEFSCOPE, null);
        Assert.assertEquals((Object)expected, (Object)got);
    }

    @Test
    public void testCredentialsMatching() {
        UsernamePasswordCredentials creds1 = new UsernamePasswordCredentials("name1", "pass1".toCharArray());
        UsernamePasswordCredentials creds2 = new UsernamePasswordCredentials("name2", "pass2".toCharArray());
        UsernamePasswordCredentials creds3 = new UsernamePasswordCredentials("name3", "pass3".toCharArray());
        AuthScope scope1 = new AuthScope(null, null, -1, null, null);
        AuthScope scope2 = new AuthScope(null, null, -1, "somerealm", null);
        AuthScope scope3 = new AuthScope(null, "somehost", -1, null, null);
        BasicCredentialsProvider state = new BasicCredentialsProvider();
        state.setCredentials(scope1, (Credentials)creds1);
        state.setCredentials(scope2, (Credentials)creds2);
        state.setCredentials(scope3, (Credentials)creds3);
        Credentials got = state.getCredentials(new AuthScope("http", "someotherhost", 80, "someotherrealm", "Basic"), null);
        UsernamePasswordCredentials expected = creds1;
        Assert.assertEquals((Object)expected, (Object)got);
        got = state.getCredentials(new AuthScope("http", "someotherhost", 80, "somerealm", "Basic"), null);
        expected = creds2;
        Assert.assertEquals((Object)expected, (Object)got);
        got = state.getCredentials(new AuthScope("http", "somehost", 80, "someotherrealm", "Basic"), null);
        expected = creds3;
        Assert.assertEquals((Object)expected, (Object)got);
    }
}

