/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.auth;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.commons.codec.binary.Base64;
import org.apache.hc.client5.http.auth.AuthChallenge;
import org.apache.hc.client5.http.auth.AuthScope;
import org.apache.hc.client5.http.auth.ChallengeType;
import org.apache.hc.client5.http.auth.Credentials;
import org.apache.hc.client5.http.auth.CredentialsProvider;
import org.apache.hc.client5.http.auth.UsernamePasswordCredentials;
import org.apache.hc.client5.http.impl.auth.AuthChallengeParser;
import org.apache.hc.client5.http.impl.auth.BasicCredentialsProvider;
import org.apache.hc.client5.http.impl.auth.BasicScheme;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.ParseException;
import org.apache.hc.core5.http.message.BasicHttpRequest;
import org.apache.hc.core5.http.message.ParserCursor;
import org.apache.hc.core5.util.CharArrayBuffer;
import org.junit.Assert;
import org.junit.Test;

public class TestBasicScheme {
    private static AuthChallenge parse(String s) throws ParseException {
        CharArrayBuffer buffer = new CharArrayBuffer(s.length());
        buffer.append(s);
        ParserCursor cursor = new ParserCursor(0, buffer.length());
        List authChallenges = AuthChallengeParser.INSTANCE.parse(ChallengeType.TARGET, (CharSequence)buffer, cursor);
        Assert.assertEquals((long)1L, (long)authChallenges.size());
        return (AuthChallenge)authChallenges.get(0);
    }

    @Test
    public void testBasicAuthenticationEmptyChallenge() throws Exception {
        String challenge = "Basic";
        AuthChallenge authChallenge = TestBasicScheme.parse("Basic");
        BasicScheme authscheme = new BasicScheme();
        authscheme.processChallenge(authChallenge, null);
        Assert.assertNull((Object)authscheme.getRealm());
    }

    @Test
    public void testBasicAuthenticationWith88591Chars() throws Exception {
        int[] germanChars = new int[]{228, 45, 246, 45, 252};
        StringBuilder buffer = new StringBuilder();
        for (int germanChar : germanChars) {
            buffer.append((char)germanChar);
        }
        HttpHost host = new HttpHost("somehost", 80);
        AuthScope authScope = new AuthScope(host, "some realm", null);
        UsernamePasswordCredentials creds = new UsernamePasswordCredentials("dh", buffer.toString().toCharArray());
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        credentialsProvider.setCredentials(authScope, (Credentials)creds);
        BasicScheme authscheme = new BasicScheme(StandardCharsets.ISO_8859_1);
        Assert.assertTrue((boolean)authscheme.isResponseReady(host, (CredentialsProvider)credentialsProvider, null));
        BasicHttpRequest request = new BasicHttpRequest("GET", "/");
        String authResponse = authscheme.generateAuthResponse(host, (HttpRequest)request, null);
        Assert.assertEquals((Object)"Basic ZGg65C32Lfw=", (Object)authResponse);
    }

    @Test
    public void testBasicAuthentication() throws Exception {
        AuthChallenge authChallenge = TestBasicScheme.parse("Basic realm=\"test\"");
        BasicScheme authscheme = new BasicScheme();
        authscheme.processChallenge(authChallenge, null);
        HttpHost host = new HttpHost("somehost", 80);
        AuthScope authScope = new AuthScope(host, "test", null);
        UsernamePasswordCredentials creds = new UsernamePasswordCredentials("testuser", "testpass".toCharArray());
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        credentialsProvider.setCredentials(authScope, (Credentials)creds);
        BasicHttpRequest request = new BasicHttpRequest("GET", "/");
        Assert.assertTrue((boolean)authscheme.isResponseReady(host, (CredentialsProvider)credentialsProvider, null));
        String authResponse = authscheme.generateAuthResponse(host, (HttpRequest)request, null);
        String expected = "Basic " + new String(Base64.encodeBase64((byte[])"testuser:testpass".getBytes(StandardCharsets.US_ASCII)), StandardCharsets.US_ASCII);
        Assert.assertEquals((Object)expected, (Object)authResponse);
        Assert.assertEquals((Object)"test", (Object)authscheme.getRealm());
        Assert.assertTrue((boolean)authscheme.isChallengeComplete());
        Assert.assertFalse((boolean)authscheme.isConnectionBased());
    }

    @Test
    public void testBasicProxyAuthentication() throws Exception {
        AuthChallenge authChallenge = TestBasicScheme.parse("Basic realm=\"test\"");
        BasicScheme authscheme = new BasicScheme();
        authscheme.processChallenge(authChallenge, null);
        HttpHost host = new HttpHost("somehost", 80);
        AuthScope authScope = new AuthScope(host, "test", null);
        UsernamePasswordCredentials creds = new UsernamePasswordCredentials("testuser", "testpass".toCharArray());
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        credentialsProvider.setCredentials(authScope, (Credentials)creds);
        BasicHttpRequest request = new BasicHttpRequest("GET", "/");
        Assert.assertTrue((boolean)authscheme.isResponseReady(host, (CredentialsProvider)credentialsProvider, null));
        String authResponse = authscheme.generateAuthResponse(host, (HttpRequest)request, null);
        String expected = "Basic " + new String(Base64.encodeBase64((byte[])"testuser:testpass".getBytes(StandardCharsets.US_ASCII)), StandardCharsets.US_ASCII);
        Assert.assertEquals((Object)expected, (Object)authResponse);
        Assert.assertEquals((Object)"test", (Object)authscheme.getRealm());
        Assert.assertTrue((boolean)authscheme.isChallengeComplete());
        Assert.assertFalse((boolean)authscheme.isConnectionBased());
    }

    @Test
    public void testSerialization() throws Exception {
        AuthChallenge authChallenge = TestBasicScheme.parse("Basic realm=\"test\"");
        BasicScheme basicScheme = new BasicScheme();
        basicScheme.processChallenge(authChallenge, null);
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(buffer);
        out.writeObject(basicScheme);
        out.flush();
        byte[] raw = buffer.toByteArray();
        ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(raw));
        BasicScheme authScheme = (BasicScheme)in.readObject();
        Assert.assertEquals((Object)basicScheme.getName(), (Object)authScheme.getName());
        Assert.assertEquals((Object)basicScheme.getRealm(), (Object)authScheme.getRealm());
        Assert.assertEquals((Object)basicScheme.isChallengeComplete(), (Object)authScheme.isChallengeComplete());
    }

    @Test
    public void testSerializationUnchallenged() throws Exception {
        BasicScheme basicScheme = new BasicScheme();
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(buffer);
        out.writeObject(basicScheme);
        out.flush();
        byte[] raw = buffer.toByteArray();
        ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(raw));
        BasicScheme authScheme = (BasicScheme)in.readObject();
        Assert.assertEquals((Object)basicScheme.getName(), (Object)authScheme.getName());
        Assert.assertEquals((Object)basicScheme.getRealm(), (Object)authScheme.getRealm());
        Assert.assertEquals((Object)basicScheme.isChallengeComplete(), (Object)authScheme.isChallengeComplete());
    }
}

